set -x 
set -e

INSTALL_PATH="/opt/mss_rest"

while getopts ":p:h" opt; do
  case "$opt" in
    p) 
       echo "Set path to the MSS REST daemon executable"
       INSTALL_PATH=$OPTARG
       ;;
    h) 
       echo "Usage: $0  [-p (install_path)]"
       exit
       ;;
    esac
done
shift $((OPTIND-1))

cp 95-intech-ps4-scanners.rules /lib/udev/rules.d/

mkdir -p $INSTALL_PATH $INSTALL_PATH/logs
cp *so* $INSTALL_PATH
cp mss_rest $INSTALL_PATH
cp -r data $INSTALL_PATH
cp -r doc $INSTALL_PATH

cp mss_rest_daemon.service /etc/systemd/system
cp mss_rest.conf /etc/ld.so.conf.d/

sed -i -e "s|<path>|$INSTALL_PATH|g" /etc/systemd/system/mss_rest_daemon.service
sed -i -e "s|<path>|$INSTALL_PATH|g" /etc/ld.so.conf.d/mss_rest.conf
ldconfig -v
systemctl daemon-reload
systemctl enable mss_rest_daemon
systemctl start mss_rest_daemon