/*
 * Decompiled with CFR 0.152.
 */
package com.neuroair;

import com.dseelab.pov.model.DeviceState;
import com.dseelab.pov.model.FileItem;
import com.dseelab.pov.socket.SocketHelper;
import com.neuroair.Command;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class CommandHandler {
    static SocketHelper mSocketHelper = new SocketHelper();
    private WebSocketSession session;

    public CommandHandler(WebSocketSession session) {
        this.session = session;
        this.initializeConnection();
    }

    private void initializeConnection() {
        mSocketHelper.setLooping(true);
        mSocketHelper.setRepeat(3);
        this.connectToDevice();
    }

    private boolean connectToDevice() {
        System.out.println("Attempting to connect...");
        boolean isSuccess = mSocketHelper.connect("DseeLab_60H_60002999");
        System.out.println("connect result\u043f\u0458\u0459" + isSuccess);
        return isSuccess;
    }

    public void execute(@NotNull Command command) {
        if (!mSocketHelper.isConnect()) {
            System.out.println("Reconnecting...");
            this.connectToDevice();
        }
        switch (command.getMethod()) {
            case "start": {
                System.out.println("command: start");
                this.openDevice();
                break;
            }
            case "stop": {
                System.out.println("command: stop");
                this.closeDevice();
                break;
            }
            case "setLight": {
                System.out.println("command: setLight");
                int bright = Integer.parseInt(command.getArgs());
                boolean lightResult = mSocketHelper.setLight(bright);
                System.out.println("setLight result\u043f\u0458\u0459" + lightResult);
                break;
            }
            case "setAngle": {
                System.out.println("command: setAngle");
                int angle = Integer.parseInt(command.getArgs());
                boolean angleResult = mSocketHelper.setAngle(angle);
                System.out.println("setAngle result\u043f\u0458\u0459" + angleResult);
                break;
            }
            case "openDevice": {
                System.out.println("command: openDevice");
                this.openDevice();
                break;
            }
            case "closeDevice": {
                System.out.println("command: closeDevice");
                this.closeDevice();
                break;
            }
            case "pausePlayer": {
                System.out.println("command: pausePlayer");
                boolean pauseResult = mSocketHelper.pausePlayer();
                System.out.println("pausePlayer result\u043f\u0458\u0459" + pauseResult);
                break;
            }
            case "resumePlayer": {
                System.out.println("command: resumePlayer");
                boolean resumeResult = mSocketHelper.resumePlayer();
                System.out.println("resumePlayer result\u043f\u0458\u0459" + resumeResult);
                break;
            }
            case "playVideo": {
                System.out.println("command: playVideo");
                this.playVideoByName(command.getArgs());
                break;
            }
            case "playVideoNTimes": {
                System.out.println("command: playVideoNTimes");
                this.playVideoNTimes(command.getArgs());
                break;
            }
            case "playVideoLoop": {
                System.out.println("command: playVideoLoop");
                this.playVideoLoop(command.getArgs());
                break;
            }
            case "readDeviceState": {
                System.out.println("command: readDeviceState");
                DeviceState deviceState = mSocketHelper.readDeviceState();
                System.out.println("deviceState\u043f\u0458\u0459" + deviceState);
                break;
            }
            case "uploadFile": {
                System.out.println("command: uploadFile");
                break;
            }
            case "readFileList": {
                System.out.println("command: readFileList");
                List fileList = mSocketHelper.readCurrentPlayList();
                if (fileList == null) break;
                System.out.println("fileList size: " + fileList.size());
                this.sendMessage("File List:");
                for (FileItem fileItem : fileList) {
                    System.out.println(fileItem.getFileName());
                    this.sendMessage(fileItem.getFileName());
                }
                break;
            }
            default: {
                System.out.println("command: unknown command");
            }
        }
    }

    private void sendMessage(String message) {
        try {
            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void playVideoByName(String name) {
        List fileList = mSocketHelper.readCurrentPlayList();
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                if (!((FileItem)fileList.get(i)).getFileName().equals(name)) continue;
                mSocketHelper.playVideo(i);
                break;
            }
        }
    }

    private void playVideoNTimes(String args) {
        String[] parts = args.split(",");
        String name = parts[0];
        int times = Integer.parseInt(parts[1]);
        List fileList = mSocketHelper.readCurrentPlayList();
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                if (!((FileItem)fileList.get(i)).getFileName().equals(name)) continue;
                for (int j = 0; j < times; ++j) {
                    mSocketHelper.playVideo(i);
                }
                break;
            }
        }
    }

    private void playVideoLoop(String name) {
        List fileList = mSocketHelper.readCurrentPlayList();
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                if (!((FileItem)fileList.get(i)).getFileName().equals(name)) continue;
                mSocketHelper.setLooping(true);
                mSocketHelper.playVideo(i);
                break;
            }
        }
    }

    public void closeConnection() {
        if (mSocketHelper != null && mSocketHelper.isConnect()) {
            mSocketHelper.close();
            System.out.println("Socket connection closed.");
        }
    }

    private void openDevice() {
        boolean result = mSocketHelper.openDevice();
        System.out.println("openDevice result: " + result);
    }

    private void closeDevice() {
        boolean result = mSocketHelper.closeDevice();
        System.out.println("closeDevice result: " + result);
    }
}

