/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.ffmpeg;

import com.dseelab.pov.PovException;
import com.dseelab.pov.ffmpeg.StreamManage;
import java.io.File;
import java.io.IOException;

public class FFmpegUtils {
    private static FFmpegUtils mInstance;
    public static String RESOLUTION;
    public static String BIT_RATE;

    private FFmpegUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FFmpegUtils getInstance() {
        if (mInstance != null) return mInstance;
        Class<FFmpegUtils> clazz = FFmpegUtils.class;
        synchronized (FFmpegUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new FFmpegUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private int checkContentType(String inputPath) {
        String type = inputPath.substring(inputPath.lastIndexOf(".") + 1).toLowerCase();
        if (type.equals("fig") || type.equals("mp4") || type.equals("avi") || type.equals("mkv") || type.equals("rmvb") || type.equals("wmv") || type.equals("mov") || type.equals("flv")) {
            return 1;
        }
        if (type.equals("jpg") || type.equals("jpeg") || type.equals("png") || type.equals("bmp")) {
            return 2;
        }
        return 9;
    }

    public String[] transCode(String ... pathArray) throws IOException, PovException, InterruptedException {
        for (int i = 0; i < pathArray.length; ++i) {
            String command;
            String inputPath = pathArray[i];
            String outputPath = this.getOutputPath(inputPath);
            int type = this.checkContentType(inputPath);
            if (type == 1) {
                command = "ffmpeg -i " + inputPath + " -c:v libx264 -vprofile baseline -level 3 -s " + RESOLUTION + " -r 24 -refs 1 -b:v " + BIT_RATE + " -c:a libmp3lame -ac 2 -ar 22050 -pix_fmt yuvj420p " + outputPath;
            } else if (type == 2) {
                command = "ffmpeg -loop 1 -i " + inputPath + " -c:v libx264 -vprofile baseline " + "-level 3 -s " + RESOLUTION + " -r 24 -refs 1 -b:v " + BIT_RATE + " -ac 2 -ar 22050 -pix_fmt yuvj420p -t 5 " + outputPath;
            } else {
                throw new PovException("File format currently uploaded is not supported\n");
            }
            Runtime rt = Runtime.getRuntime();
            Process process = rt.exec(command);
            StreamManage errorStream = new StreamManage(process.getErrorStream(), "Error");
            StreamManage outputStream = new StreamManage(process.getInputStream(), "Output");
            errorStream.start();
            outputStream.start();
            process.waitFor();
            process.destroy();
            System.out.println("Transcoding complete");
            pathArray[i] = outputPath;
        }
        return pathArray;
    }

    private String getOutputPath(String inputPath) throws PovException {
        File file = new File(inputPath);
        if (file.exists()) {
            File parentFile = file.getParentFile();
            File temp = new File(parentFile, "temp");
            if (!temp.exists()) {
                temp.mkdirs();
            }
            return temp.getPath() + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")) + ".mp4";
        }
        throw new PovException("File not exist:" + inputPath);
    }

    static {
        RESOLUTION = "512x512";
        BIT_RATE = "1M";
    }
}

