/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.socket;

import com.dseelab.pov.PovException;
import com.dseelab.pov.ffmpeg.FFmpegUtils;
import com.dseelab.pov.model.BtInfo;
import com.dseelab.pov.model.DeviceState;
import com.dseelab.pov.model.FileItem;
import com.dseelab.pov.model.ShaderConfig;
import com.dseelab.pov.model.VideoItem;
import com.dseelab.pov.socket.SocketClient;
import com.dseelab.pov.ssdp.CallBack;
import com.dseelab.pov.ssdp.SsdpClient;
import com.dseelab.pov.util.FileUtils;
import com.dseelab.pov.util.Utils;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketHelper {
    private SocketClient mSocketClient = new SocketClient();

    public void setLooping(boolean isLooping) {
        this.mSocketClient.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.mSocketClient.isLooping;
    }

    public void setRepeat(int count) {
        this.mSocketClient.mRepeat = count;
    }

    public int getRepeat() {
        return this.mSocketClient.mRepeat;
    }

    public boolean isConnect() {
        return this.mSocketClient.isConnect();
    }

    public boolean connect(String deviceSn) {
        this.mSocketClient.setIp(Utils.setConfig(deviceSn));
        return this.mSocketClient.connect(this.mSocketClient.getIp(), null);
    }

    public boolean connect(String ip, String passWord, String deviceSn) {
        Utils.setConfig(deviceSn);
        return this.mSocketClient.connect(ip, passWord);
    }

    public void close() {
        this.mSocketClient.close();
    }

    public void searchDeviceIp(CallBack callBack) {
        SsdpClient ssdpClient = new SsdpClient();
        ssdpClient.setCallBack(callBack);
        ssdpClient.search();
    }

    public boolean openDevice() {
        return this.mSocketClient.sendControl((byte)1, 0);
    }

    public boolean closeDevice() {
        return this.mSocketClient.sendControl((byte)2, 0);
    }

    public boolean setLight(int light) {
        return this.mSocketClient.sendControl((byte)3, light);
    }

    public boolean removeVideo(int position) {
        return this.mSocketClient.sendControl((byte)4, (byte)0, position);
    }

    public boolean deleteVideo(int position) {
        return this.mSocketClient.sendControl((byte)4, (byte)1, position);
    }

    public boolean deleteList(int position) {
        return this.mSocketClient.sendControl((byte)52, position);
    }

    public boolean usePlayList(int position) {
        return this.mSocketClient.sendControl((byte)53, position);
    }

    public boolean clearList() {
        return this.mSocketClient.sendControl((byte)5, (byte)0, 0);
    }

    public boolean clearAllVideo() {
        return this.mSocketClient.sendControl((byte)5, (byte)1, 0);
    }

    public boolean pausePlayer() {
        return this.mSocketClient.sendControl((byte)6, 0);
    }

    public boolean resumePlayer() {
        return this.mSocketClient.sendControl((byte)7, 0);
    }

    public boolean playVideo(int position) {
        return this.mSocketClient.sendControl((byte)8, position);
    }

    public DeviceState readDeviceState() {
        return this.mSocketClient.readDeviceState((byte)10, 0);
    }

    public List<FileItem> readCurrentPlayList() {
        return this.mSocketClient.readPlayList((byte)11, (byte)0, 0);
    }

    public List<FileItem> readPlayList(int position) {
        return this.mSocketClient.readPlayList((byte)11, (byte)1, position);
    }

    public List<String> readFileList() {
        return this.mSocketClient.readFileList((byte)11, (byte)2);
    }

    public List<VideoItem> readVideoList() {
        return this.mSocketClient.readPlayList((byte)11, (byte)3, 0);
    }

    public List<BtInfo> readBluetoothList() {
        return this.mSocketClient.readBluetoothList((byte)47, 0);
    }

    public int readCurrentPosition() {
        return this.mSocketClient.readCurrentIndex((byte)12, (byte)0);
    }

    public String readCurrentName() {
        return this.mSocketClient.readCurrentName((byte)12, (byte)1);
    }

    public int readCurrentListPosition() {
        return this.mSocketClient.readCurrentIndex((byte)12, (byte)2);
    }

    public String readCurrentListName() {
        return this.mSocketClient.readCurrentName((byte)12, (byte)3);
    }

    public boolean updateFileList(String listName, List<FileItem> videoList) {
        return this.mSocketClient.updateFileList(listName, videoList);
    }

    public boolean updateFileList(List<FileItem> videoList) {
        return this.mSocketClient.updateFileList(null, videoList);
    }

    public List<FileItem> uploadFile(String[] inputPath) throws IOException, PovException, InterruptedException {
        String[] outputPathArray = FFmpegUtils.getInstance().transCode(inputPath);
        List<FileItem> fileList = this.mSocketClient.sendFile(outputPathArray);
        for (String path : outputPathArray) {
            FileUtils.deleteFile(path);
        }
        return fileList;
    }

    public boolean ap2Sta(String wifi, String pwd) {
        return this.mSocketClient.sendWifi((byte)18, wifi, pwd);
    }

    public boolean sta2Ap() {
        return this.mSocketClient.sendControl((byte)24, 0);
    }

    public boolean setHorizontalOffset(int offset) {
        return this.mSocketClient.sendControl((byte)32, offset);
    }

    public boolean setVerticalOffset(int offset) {
        return this.mSocketClient.sendControl((byte)33, offset);
    }

    public boolean setShaderMode(int mode) {
        return this.mSocketClient.sendControl((byte)34, mode);
    }

    public boolean setWhiteBackground(int mode) {
        return this.mSocketClient.sendControl((byte)35, mode);
    }

    public boolean setInnerLength(int length) {
        return this.mSocketClient.sendControl((byte)36, length);
    }

    public boolean setBlurLength(int length) {
        return this.mSocketClient.sendControl((byte)37, length);
    }

    public boolean setRightAngle(int angle) {
        return this.mSocketClient.sendControl((byte)38, angle);
    }

    public boolean setRightDistance(int distance) {
        return this.mSocketClient.sendControl((byte)39, distance);
    }

    public boolean setTopAngle(int angle) {
        return this.mSocketClient.sendControl((byte)40, angle);
    }

    public boolean setTopDistance(int distance) {
        return this.mSocketClient.sendControl((byte)41, distance);
    }

    public boolean setLeftAngle(int angle) {
        return this.mSocketClient.sendControl((byte)42, angle);
    }

    public boolean setLeftDistance(int distance) {
        return this.mSocketClient.sendControl((byte)43, distance);
    }

    public boolean setBottomAngle(int angle) {
        return this.mSocketClient.sendControl((byte)44, angle);
    }

    public boolean setBottomDistance(int distance) {
        return this.mSocketClient.sendControl((byte)45, distance);
    }

    public ShaderConfig readShaderConfig() {
        return this.mSocketClient.readShaderConfig((byte)46, 0);
    }

    public boolean openTiming(String startTime, String endTime) {
        return this.mSocketClient.sendTiming((byte)13, startTime, endTime);
    }

    public boolean closeTiming() {
        return this.mSocketClient.sendControl((byte)14, 0);
    }

    public boolean setAngle(int angle) {
        return this.mSocketClient.sendControl((byte)17, angle);
    }

    public boolean setVolume(int volume) {
        return this.mSocketClient.sendControl((byte)20, volume);
    }

    public boolean setBreath(int breath) {
        return this.mSocketClient.sendControl((byte)21, breath);
    }

    public boolean setBluetooth(int bluetooth) {
        return this.mSocketClient.sendControl((byte)22, bluetooth);
    }

    public boolean setSelfStart(int selfStart) {
        return this.mSocketClient.sendControl((byte)23, selfStart);
    }

    public boolean connectBluetooth(String btAddress) {
        return this.mSocketClient.connectBluetooth((byte)48, btAddress);
    }

    public boolean setServerType(int serverType) {
        return this.mSocketClient.sendControl((byte)49, serverType);
    }

    public boolean restartSystem() {
        return this.mSocketClient.sendControl((byte)51, 0);
    }

    public boolean deletePlayList(int position) {
        return this.mSocketClient.sendControl((byte)52, 0);
    }

    public boolean setSwitchInterval(int interval) {
        return this.mSocketClient.sendControl((byte)54, interval);
    }

    public boolean setMotorSpeed(int speed) {
        return this.mSocketClient.sendControl((byte)55, speed);
    }

    public boolean setRemoteControl(boolean isUse) {
        return this.mSocketClient.sendControl((byte)56, isUse ? 0 : 1);
    }

    public boolean setMotorEmergency(boolean isUse) {
        return this.mSocketClient.sendControl((byte)57, isUse ? 1 : 0);
    }
}

