/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;

public final class FileUtils {
    private static final String TAG = "FileUtils";

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isExists(String path) {
        return FileUtils.isExists(FileUtils.getFileByPath(path));
    }

    public static boolean isExists(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static File getFileByPath(String filePath) {
        return FileUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && file.exists() && file.isFile() && file.delete();
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeFileFromIS(String filePath, InputStream is, long fileLength) throws IOException {
        long l;
        long total;
        File file = FileUtils.getFileByPath(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file == null || is == null) {
            return 0L;
        }
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(file);
            byte[] data = new byte[65536];
            for (total = 0L; total < fileLength && (len = is.read(data)) != -1; total += (long)len) {
                fos.write(data, 0, len);
            }
            fos.flush();
            l = total;
        }
        catch (IOException e) {
            long l2;
            try {
                e.printStackTrace();
                l2 = total;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(fos);
                throw throwable;
            }
            FileUtils.closeIO(fos);
            return l2;
        }
        FileUtils.closeIO(fos);
        return l;
    }

    public static long writeFileFromIs(String path, long startPos, long fileLength, InputStream inputStream) throws IOException {
        long total;
        try {
            File file = FileUtils.getFileByPath(path);
            if (!file.exists()) {
                return 0L;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
            randomAccessFile.seek(startPos);
            byte[] buffer = new byte[65536];
            int len = -1;
            for (total = startPos; total < fileLength && (len = inputStream.read(buffer)) != -1; total += (long)len) {
                randomAccessFile.write(buffer, 0, len);
            }
            randomAccessFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String charsetName) {
        String string;
        if (!FileUtils.isExists(file)) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuilder sb = new StringBuilder();
            reader = FileUtils.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            String line = reader.readLine();
            if (line != null) {
                sb.append(line);
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            string = sb.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(reader);
                throw throwable;
            }
            FileUtils.closeIO(reader);
            return string2;
        }
        FileUtils.closeIO(reader);
        return string;
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getFileSize(long fileLength) {
        long answer;
        long temp = fileLength;
        String sym = null;
        if (fileLength < 1024L) {
            sym = "B";
            answer = temp;
        } else if (fileLength < 0x100000L) {
            sym = "K";
            answer = temp / 1024L;
        } else if (fileLength < 0x40000000L) {
            sym = "M";
            answer = temp / 1024L / 1024L;
        } else {
            sym = "G";
            answer = temp / 1024L / 1024L / 1024L;
        }
        return answer + sym;
    }
}

