/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.util;

import com.dseelab.pov.ffmpeg.FFmpegUtils;
import com.dseelab.pov.model.FileItem;
import com.dseelab.pov.model.VideoItem;
import com.dseelab.pov.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static byte[] getCommand(byte order, int date) {
        byte[] send = new byte[6];
        send[0] = 5;
        send[1] = 53;
        send[2] = -92;
        send[3] = order;
        byte[] buffer = Utils.shortToByteArray(date);
        send[4] = buffer[0];
        send[5] = buffer[1];
        return send;
    }

    public static byte[] getCommand(byte order, byte type, int date) {
        byte[] send = new byte[]{5, 53, -92, order, type, (byte)date};
        return send;
    }

    public static byte[] getWifiCommand(byte order, String wifi, String pwd) {
        byte[] send = new byte[6 + wifi.length() + pwd.length()];
        send[0] = (byte)(send.length - 1);
        send[1] = 53;
        send[2] = -92;
        send[3] = order;
        send[4] = (byte)wifi.length();
        send[5] = (byte)pwd.length();
        System.arraycopy(wifi.getBytes(), 0, send, 6, wifi.length());
        System.arraycopy(pwd.getBytes(), 0, send, 6 + wifi.length(), pwd.length());
        return send;
    }

    public static byte[] getTimingCommand(String startTime, String endTime) {
        byte[] send = new byte[42];
        send[0] = 41;
        send[1] = 53;
        send[2] = -92;
        send[3] = 13;
        send[4] = 19;
        send[5] = 8;
        send[6] = 8;
        System.arraycopy(TimeUtils.getNowString().getBytes(), 0, send, 7, 19);
        System.arraycopy(startTime.getBytes(), 0, send, 26, 8);
        System.arraycopy(endTime.getBytes(), 0, send, 34, 8);
        return send;
    }

    public static byte[] getBtAddressCommand(String btAddress) {
        byte[] send = new byte[5 + btAddress.length()];
        send[0] = (byte)(send.length - 1);
        send[1] = 53;
        send[2] = -92;
        send[3] = 48;
        send[4] = (byte)btAddress.length();
        System.arraycopy(btAddress.getBytes(), 0, send, 5, btAddress.length());
        return send;
    }

    public static boolean checkSuccess(byte[] result, byte instruction) {
        return result[0] == 53 && result[1] == -92 && result[2] == instruction;
    }

    public static byte[] longToByte(long data) {
        byte[] bytes = new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data & 0xFFL)};
        return bytes;
    }

    public static byte[] shortToByteArray(int s) {
        byte[] shortBuf = new byte[2];
        for (int i = 0; i < 2; ++i) {
            int offset = (shortBuf.length - 1 - i) * 8;
            shortBuf[i] = (byte)(s >>> offset & 0xFF);
        }
        return shortBuf;
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static long byteToLong(byte[] bytes) {
        long value = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            int shift = (bytes.length - 1 - i) * 8;
            value += (long)(bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static List<FileItem> parsePlayList(String str) {
        ArrayList<FileItem> list = new ArrayList<FileItem>();
        if (str != null && str != "") {
            Pattern pat = Pattern.compile(",");
            String[] tempStr = pat.split(str.replace("\r\n", ""));
            for (int i = 0; i < tempStr.length / 3; ++i) {
                FileItem item = new FileItem();
                item.setFileName(tempStr[3 * i]);
                item.setFileSize(tempStr[3 * i + 1]);
                item.setRepeatCount(tempStr[3 * i + 2]);
                list.add(item);
            }
        }
        return list;
    }

    public static List<VideoItem> parseVideoList(String str) {
        ArrayList<VideoItem> list = new ArrayList<VideoItem>();
        if (str != null && str != "") {
            Pattern pat = Pattern.compile(";");
            String[] tempStr = pat.split(str.replace("\r\n", ""));
            for (int i = 0; i < tempStr.length / 3; ++i) {
                VideoItem item = new VideoItem();
                item.setFileName(tempStr[3 * i]);
                item.setFileSize(tempStr[3 * i + 1]);
                item.setPeriod(tempStr[3 * i + 2]);
                list.add(item);
            }
        }
        return list;
    }

    public static List<String> parseFileListList(String str) {
        if (str != null && str != "") {
            Pattern pat = Pattern.compile(",");
            String[] tempStr = pat.split(str.replace("\n", ","));
            return Arrays.asList(tempStr);
        }
        return null;
    }

    public static String listToString(List<FileItem> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (FileItem item : list) {
            sb.append(item.getFileName());
            sb.append(",");
            sb.append(item.getFileSize());
            sb.append(",");
            sb.append(item.getRepeatCount());
            sb.append(",\r\n");
        }
        return sb.toString();
    }

    public static String setConfig(String deviceSn) {
        String ip;
        String[] split = deviceSn.split("_");
        if (split != null && split.length >= 2) {
            String type = split[1].toLowerCase();
            if ("50z".equals(type) || "50s".equals(type) || "65z".equals(type)) {
                ip = "192.168.2.1";
                FFmpegUtils.RESOLUTION = "512x512";
            } else if ("65s".equals(type) || "65h".equals(type) || "65x".equals(type)) {
                ip = "192.168.2.1";
                FFmpegUtils.RESOLUTION = "720x720";
            } else if ("100z".equals(type) || "1m768".equals(type)) {
                ip = "192.168.0.1";
                FFmpegUtils.RESOLUTION = "768x768";
            } else if ("100s".equals(type) || "1m1024".equals(type)) {
                ip = "192.168.0.1";
                FFmpegUtils.RESOLUTION = "1024x1024";
            } else if ("100h".equals(type)) {
                ip = "192.168.43.1";
                FFmpegUtils.RESOLUTION = "1024x1024";
            } else if ("60h".equals(type)) {
                ip = "192.168.43.1";
                FFmpegUtils.RESOLUTION = "720x720";
            } else if ("78h".equals(type)) {
                ip = "192.168.43.1";
                FFmpegUtils.RESOLUTION = "960x960";
            } else {
                ip = "10.0.0.0";
            }
        } else {
            ip = "10.0.0.0";
        }
        return ip;
    }
}

