const cameras = require('../index');
const { Camera } = require('../index');

//Выводит сообщение на страницу
const showMessage = (type, ...args) => {
    args = ['[cameras]', ...args];
    let message = '';
    if (Array.isArray(args)) args.forEach(arg => {
        if (typeof arg === 'object') {
            message += JSON.stringify(arg, null, '\t');
        } else {
            message += arg;
        };
        message += ' ';
    });

    switch (type) {
        case 'info':
            console.log(message);
            break;
        case 'warn':
            console.warn(message);
            break;
        case 'error':
            console.error(message);
            break;        
        default:
            console.log(message);
            break;
    };

    //Если удалось найти HTML элементы для сообщений, дублируем сообщения в них
    const messageElem = document.getElementById('message');
    const messageConteiner= document.getElementById('message-conteiner');
    if (messageElem && messageConteiner) {
        messageConteiner.classList.add('show');
        messageElem.innerText += '\n\n' + message;
        messageElem.classList = type;
        messageConteiner.scrollTo(0, messageConteiner.scrollHeight);
    };
};

//Логгер
const log = {
    info: (...args) => showMessage('info', ...args),
    warn: (...args) => showMessage('warn', ...args),
    error: (...args) => showMessage('error', ...args)
};

//Подписываемся на события сообщений
cameras.on('info', (info) => {
    log.info(info);
});
cameras.on('error', (error) => {
    log.error(error);
});
cameras.on('stop-all', () => {
    log.info(`Стримы со всех камер успешно остановлены`);
});

//Получим список подключенных камер
cameras.getCameras().then(list => {
    log.info('Список подключенных камер:', list);

    //Найдём необходимую камеру (для примера возьмём первую из списка подключенных)
    cameras.findCamera(list[0]).then(result => {
        switch (result.status) {
            case 'found':
                log.info(result.info);

                //Создаём экземпляр первой камеры
                const firstCamera = new Camera;

                //Подписываемся на события сообщений
                firstCamera.on('info', (info) => {
                    log.info(info);
                });
                firstCamera.on('error', (error) => {
                    log.error(error);
                });
                firstCamera.on('stop', (camera) => {
                    log.info(`Стрим с камеры "${camera.name}" (${camera.id}) успешно остановлен`);
                });
                firstCamera.on('disconnect', (camera) => {
                    log.error(`Связь с камерой "${camera.name}" (${camera.id}) потеряна`);
                });

                //Подписываемся на событие подключения к камере
                firstCamera.on('stream', (stream) => {

                    const video = document.getElementById('camera');
                    if (video) {
                        //Вещаем стрим в видеоэлемент
                        video.srcObject = stream;

                        if (screen.width > screen.height) {
                            video.style.height = '100%';
                            video.style.width = 'auto';
                        } else {
                            video.style.height = 'auto';
                            video.style.width = '100%';
                        };
                    } else {
                        log.error('HTML элемент видео "camera" не найден')
                    };
                });

                //Если камера найдена, пытаемся подключиться к ней
                firstCamera.start(result.camera);

                break;
            case 'dublicate':
                log.warn(result.info);
                //При дублирывании камеры мы можем попытаться подключиться к ней,
                //но не сможем точьно сказать к какой именно удасться подключиться
                break;
            case 'not found':
                log.error(result.info);
                break;
            default:
                log.error(`Не удалось найти камеру. Ошибка: Неизвестный ответ функции поиска камер "${result.status}"`);
                break;
        };
    }).catch(error => {
        log.error('Не удалось найти камеру. Ошибка:', error.message || 'Неизвестная ошибка');
    });

    //Если подключена вторая камера, запускаем с неё в фоновом режиме
    if (list[1]) {
        const secondCamera = new Camera;

        //Подписываемся на события сообщений
        secondCamera.on('info', (info) => {
            log.info(info);
        });
        secondCamera.on('error', (error) => {
            log.error(error);
        });
        secondCamera.on('stop', (camera) => {
            log.info(`Стрим с камеры "${camera.name}" (${camera.id}) успешно остановлен`);
        });
        secondCamera.on('disconnect', (camera) => {
            log.error(`Связь с камерой "${camera.name}" (${camera.id}) потеряна`);
        });

        secondCamera.start(list[1]);
        setTimeout(() => {
            //Остановим стрим со второй камеры через 10 секунд
            secondCamera.stop(list[1]);
        }, 10000);
    };

}).catch(error => {
    log.error('Не удалось получить список камер. Ошибка:', error.message || 'Неизвестная ошибка');
});