'use strict';
Object.defineProperty(exports, '__esModule', { value: true });
const utils_1 = require('../../utils');
let newFields = [];
// объединяет конфиги
const syncConfigsEntry = (remoteConfig, localConfig, defaultConfig, newFieldsArr) => {
  if (!localConfig && !remoteConfig) {
    return defaultConfig;
  }
  newFields = newFieldsArr;
  newFields.length = 0;
  const synchronizedConfig = syncConfigsRecursion(
    localConfig || {},
    remoteConfig || {},
    defaultConfig || {},
  );
  (0, utils_1.emit)('info', 'конфиги синхронизированы');
  return synchronizedConfig;
};
// рекурсивная синхронизация 3х конфигов
const syncConfigsRecursion = (localConfig, remoteConfig, defaultConfig) => {
  const synchronizedConfig = {};
  const config = { ...defaultConfig, ...localConfig, ...remoteConfig };
  Object.keys(config).forEach((key) => {
    var _a, _b, _c, _d;
    synchronizedConfig[key] = config[key];
    if (
      typeof config[key].value === 'object' &&
      !Array.isArray((_a = config[key]) === null || _a === void 0 ? void 0 : _a.value)
    ) {
      synchronizedConfig[key].value = syncConfigsRecursion(
        ((_b = localConfig[key]) === null || _b === void 0 ? void 0 : _b.value) || {},
        ((_c = remoteConfig[key]) === null || _c === void 0 ? void 0 : _c.value) || {},
        ((_d = defaultConfig[key]) === null || _d === void 0 ? void 0 : _d.value) || {},
      );
    }
    if (!localConfig[key] && remoteConfig[key]) {
      newFields.push(key);
    }
  });
  return synchronizedConfig;
};
exports.default = syncConfigsEntry;
//# sourceMappingURL=syncConfig.js.map
