let isConfigChanged = false;

// проверяет целостность дефолтного и локального конфига 
const checkConfig = (config: DynamicObject): boolean => {
  checkConfigRecursion(config);

  return isConfigChanged;
};

const checkConfigRecursion = (config: DynamicObject) => {
  const keys = Object.keys(config);

  keys.forEach((key) => {
    const prop = config[key];

    if (typeof prop.value === 'number') {
      checkNumberValue(prop);
    }

    if (prop.value === undefined) {
      prop.value = '';
      isConfigChanged = true;
    }

    if (typeof prop.value === 'object' && prop.value !== null) {
      checkConfigRecursion(prop.value);
    }
  });
};

// проверяет численные значение
// сверяет их с полями "step" и "type" и изменяет их в случае необходимости 
const checkNumberValue = (prop: DynamicObject) => {
  const isFloat = prop.value.toString().includes('.');

  if (!prop.type) {
    prop.type = isFloat ? 'float' : 'integer';
    isConfigChanged = true;
  } else if (prop.type === 'integer' && isFloat) {
    prop.type = 'float';
    isConfigChanged = true;
  }

  if (!prop.step || prop.value < prop.step) {
    const dividedNumber = (prop.value.toString() as string).split('.');

    prop.step = createPropStep(dividedNumber);
    isConfigChanged = true;
  }
};

// создаёт значение для поля "step"
const createPropStep = (dividedNumber: string[]) => {
  if (dividedNumber.length === 1) {
    return '1';
  } else {
    return '0.' + '0'.repeat(+dividedNumber[1].length - 1) + '1';
  }
};

export default checkConfig;
