# Feedback Module #
> Версия: 2.4.0

---

## Описание:
> Модуль предоставляет функционал для отправки обратной связи в аудио/видео и текстовом формате.

## Структура:
* Основной файл - ./dist/index.js, предоставляет функции для создания, обработки и отправки данных.

## Подключение:
* ### Посмотреть пример работы пакета:
	1. В директории ./example находится пример приложения (electron), предназначенный для ознакомления с работой модуля.
		- находясь в директории ./example, выполнить команду "npm start";
	2. В директории ./example/serverExample находится пример сервера.
		- находясь в директории ./example/serverExample выполнить "node serverExample.js";
* ### Подключить пакет к проекту:
	1. Установить пакет: npm install @neuro-city/feedback;
	2. Импортировать модуль в необходимый файл кода ( const feedback = require('@neuro-city/feedback') ).

## Интерфейс:
* ### Интерфейс
	1. В пакете экспортируется feedbackEmitter. Вы можете подписаться на каждое из событий и добавить свою логику обработки.
	События:
		1. 'error' - эмит ошибки. Существующие ошибки на данный момент:

			1. 'Not valid grade value' - ошибка возникает в случае, если в функцию handleGrade передаётся значение gradeValue, превышающее maxGradeValue;
			2. 'Mobile number value is empty' - отсутствует тел. номер, эмит происходит внутри функции handleMobileNumber;
			3. 'Mobile number is not valid' - тел. номер не прошёл валидацию, эмит происходит внутри функции handleMobileNumber;
			4. 'Full name value is empty' - отсутствует имя, эмит происходит внутри функции handleFullName;
			5. 'Text content value is empty' - отсутствует текст отзыва, эмит происходит внутри функции handleTextFeedback;
			6. 'Email value is empty' - отсутствует email, эмит происходит внутри функции handleEmail;
			7. 'Email is not valid' - email не прошёл валидацию, эмит происходит внутри функции handleEmail;
			8. 'No audio content' - отсутствует отзыв в аудио формате, эмит происходит внутри функции handleAudio;
			9. 'No video content' - отсутствует отзыв в видео формате, эмит происходит внутри функции handleVideo;
			10. 'handling-video' - конвертация видео не завершена. При переданном в функцию инициализации значении rotation, на клиент отдаётся
				исходное видео (без изменений, чтобы избежать задержки), параллельно создаётся копия видео файла, к которой применяется rotation.
				Это занимает некоторое время, после копия добавляется в объект запроса. В случае, если конвертация не завершена и видео ещё не добавлено
				в объект запроса, но на клиенте вызывается функция submit, происходит эмит данного сообщения и выход из функции. Данные отправлены не будут.
		2. 'inited' - событие успешной инициализации пакета;
		3. 'event' - эмит события. Существующий события:
			2. 'video-added' - видео в кодировке base64 добавлено в объект запроса;
			3. 'photo-added' - фото в кодировке base64 добавлено в объект запроса;
			4. 'audio-added' - аудио в кодировке base64 добавлено в объект запроса;
		4. 'data' - эмит передачи данных. Данные, передающиеся на данный момент:
			1. Response от сервера (внутри функции submitData());
		5. 'sended' - событие успешной отправки пакета;
		
	2. Экспортируется ряд функций:
		1. handleTextFeedback(textValue) - функция принимает текстовое значение отзыва и добавляет в объект запроса
		поля: content: textValue, type: 'text'. В случае вызова функции без аргументов - эмит 'Text content value is empty'
		и завершение работы функции.
		2. handleFullName(textValue) - функция принимает текстовое значение с именем и добавляет в объект запроса
		поле: fullName: textValue; В случае вызова функции без аргументов - эмит 'Full name value is empty'
		и завершение работы функции.
		3. handleMobileNumber(textValue) - функция принимает текстовое значение с тел. номером и добавляет в объект запроса
		поле: mobileNumber: textValue. В случае вызова функции без аргументов - эмит 'Mobile number value is empty'
		и завершение работы функции. Если аргумент функции не прошёл валидацию - эмит 'Mobile number is not valid'
		и завершение работы функции.
		4. handleEmail(textValue) - функция принимает текстовое значение с адресом эл. почты и добавляет в объект запроса
		поле: email: textValue. В случае вызова функции без аргументов - эмит 'Email value is empty'
		и завершение работы функции. Если аргумент функции не прошёл валидацию - эмит 'Email 
		is not valid' и завершение работы функции.
		5. handleGrade(gradeValue, maxGradeValue = 5, name, type) - функция принимает текущую оценку пользователя (число) и максимальную оценку (число)
		в зависимости от выбранной системы, а также необязательные параметры - наименование объекта оценки (строка) и тип объекта оценки (строка). Добавляет в объект запроса поле grade с вычисленным значением.
			maxGradeValue = 2: система оценки плохо/хорошо (в функцию передаются значения 1 или 2);
			maxGradeValue = 5 (по умолчанию): система оценки очень плохо/плохо/нормально/хорошо/отлично (в функцию передаются значения от 1 до 5);
			maxGradeValue = 10: десятибалльная система оценки (в функцию передаются значения от 1 до 10);
		В случае, если переданное значение gradeValue, превышает maxGradeValue, происходит эмит ошибки, в объект запроса полученное значение
		не добавляется. ( feedbackEmitter.emit('error', new Error("Not valid grade value")) ).
		6. getAudioHandlers(stream) - возвращает три функции: [startAudio, stopAudio, stopAudioStream] = getAudioHandlers(stream)
		для старта, завершения записи аудио и остановки всех треков стрима. После завершения записи, в объект запроса добавляются поля:
		content: audioBase64, type: 'audio', далее эмит события 'audio-added'.
		7. getVideoHandlers(stream) - возвращает три функции: [startVideo, stopVideo, stopVideoStream] = getVideoHandlers(stream)
		для старта, завершения записи видео и остановки всех треков стрима. После завершения записи, в объект запроса добавляются поля:
		content: videoBase64, type: 'video', далее эмит события 'video-added'.
		8. makePhoto(stream = null) - вызов функции делает кадр, после добавляет в объект запроса поля:
		photo: photoBase64. Далее эмит события 'photo-added'. Может принимать в качестве аргумента стрим.
		9. getMediaContent() - вызов функции возвращает объект следующей структуры:
		{ audio: audioContentBlob, video: videoContentBlob, photo: photoBlob }. Каждый ключ содержит последний добавленный
		медиа файл (Blob объект). В случае отсутствия контента, значение каждого ключа будет null.
		10. function submitData() - функция формирует URL, используя значения address,
		которые передаются в вызове функции инициализации, и отправляет в теле объект запроса.
		Если отзыв не содержит каких-либо оценочных данных (контент (текстовой, аудио или видео), фото или баллы), данные не отправязтся на сервер и эмитер выдаст соответствующую ошибку. 
		11. function initFeedbackModule(address, rotation = 0, email = 'feedback@neuro-city.ru', password = 'vdnhvdnh', login = 'feedback@neuro-city.ru', password = 'vdnhvdnh') -
		функция инициализации модуля, принимает значение address и rotation (для видео, отправляемого на сервер, в зависимости от настроек камеры),
		login и password (логин и пароль пользователя, по умолчанию отзыв отправляется от тестового пользователя { "name" : "Feedback", ... }), ID платформы и устройства с которых отправяется отзыв (необязательные параметры).
		Возможные значения rotation: 90, 180, 270. Передаваемое значение может быть числом или строкой.
		При отсутствии аргумента address или лигина с паролем происходит эмит сообщения об ошибке и выход из функции инициализации.
		12. clearRequestObject() - функция очистки объекта запроса кроме поля "pollFormData". Каждому ключу объекта запроса присваивается значение null.
		13. getRequestObject() - функция отдаёт копию объекта запроса, весь медиа контент (photo, video, audio) имеет значение "true".
		Если вы хотите получить медиа контент, см. функцию getMediaContent().
		14. feedbackEmitter - объект, event emitter. Вы можете подписаться на уже существующие события и добавить
		собственную логику обработки каждого из них. Пример:
			const feedback = require('@neuro-city/feedback');
			const { feedbackEmitter } = feedback;
			feedbackEmitter.on('Text content value is empty', () => {
				...
    			//логика обработки ошибки
				...
    			console.log('Text content value is empty');
			});
			feedbackEmitter.on('photo-added', () => {
    			console.log('photo added');
    			const { photo } = getMediaContent();
				...
				//добавляем фото на страницу и тд.
				...
			});

* ### Примечание

* ### Changelog 
	* v1.1.0:
		1. getVideoHandlers и getAudioHandlers возвращают функции для остановки треков стрима;
		2. автоматическая остановка треков стрима в теле функции makePhoto;
	* v1.3.0 
		1. добавлена функция handleGrade для обработки и отправки оценки пользователей;
	* v1.4.0 
		1. добавлена функция clearRequestObject для очистки объекта запроса;
		2. добавлена функция getRequestObject для получения объекта запроса (без медиа);
		3. добавлен эмит response от сервера, внутри функции submitData;
	* v2.0.0 
		1. в src добавлен index.ts, скомпиленная версия - dist/index.js;
		2. точка входа в модуль изменена на dist/index.js;
		3. эмиты разделены на группы событий ('error', 'event', 'data');
	* v2.1.0
		1. initFeedbackModule принимает email и password пользователя;
		2. добавлена авторизация при отправке данных;
	* v2.2.0
		1. makePhoto может принимать stream в качестве необязательного параметра;
    * v2.2.1
        1. исправлен эмит ошибки при отсутствующем хосте в функции initFeedbackModule
	* v2.3.0
		1. IP, порт и роуты сервера объеденены в адрес сервера;
		1. Логин и пароль пользвателя для отправки отзывов сделаны обязательными;
		1. Добавлены необязательные параметры платформы и устройства с которыз отправляется отзыв;
		1. Добавлены события успешной инициализации (inited) и отправки отзыва (sended);
		1. "Склейка" частей URL-адреса теперь осуществляется средсвами пакета "url-join" (раньше было склеивание строк).
	* v2.3.1
		1. Исправлен баг невозможности отправки оценки равной 0
		1. Из очистки объекта отзыва убрана очистка данных о платформе и устройстве ("pollFormData")
	* v2.4.0
		1. Видео после поворота теперь проигрывается в браузере
		1. Добавлены поля платформы и устойсва, убран хардкод из pollFormData
		1. Добавлены поля названия и типа оценки
