const fs = require('fs');
const express = require('express');
const app = express();
const port = 3000;

app.use(function(req, res, next) {
    res.header('Access-Control-Allow-Origin', '*');
    res.header(
      'Access-Control-Allow-Headers',
      'Origin, X-Requested-With, Content-Type, Accept'
    );
    next();
});
app.use(express.json({ limit: '50mb' }));

app.get('/', (req, res) => {
    res.send('Hello World!');
})

app.post('/', (req, res) => {
    console.log('post requset');
    console.log(req.body);
    res.send('Hello World!');
})
  
app.listen(port, () => {
    console.log(`Example app listening on port ${port}`)
})
