const { errorEmit, dataEmit, connectEmit, disconnectEmit, statusChangedEmit } = require('../events');

// Проверка параметов конфига arduino
const checkArduinoConfig = (arduinoConfig) => {
    if (!arduinoConfig || typeof arduinoConfig !== 'object') {
      errorEmit('Некорректная конфигурация Arduino. Ожидается объект.');
      return false;
    }
    if (typeof arduinoConfig.project !== 'string' || arduinoConfig.project.trim().length === 0) {
        errorEmit('Некорректное значение для названия проекта');
        return false;
    }
    if (typeof arduinoConfig.port !== 'string' || arduinoConfig.port.trim().length === 0) {
        errorEmit('Некорректное значение для порта. Ожидается непустая строка.');
        return false;
    }
    const brightness = Number(arduinoConfig.brightness);
    if (isNaN(brightness) || brightness < 0 || brightness > 255) {
      errorEmit('Некорректное значение для яркости. Ожидается число от 0 до 255.');
      return false;
    }
    const numberLED = Number(arduinoConfig.numLeds);
    if (isNaN(numberLED) || numberLED <= 0) {
      errorEmit('Некорректное значение для количества LEDs. Ожидается положительное число.');
      return false;
    }
    if (typeof arduinoConfig.color_Wait !== 'string' || !/^#[0-9A-Fa-f]{6}$/.test(arduinoConfig.color_Wait)) {
      errorEmit('Некорректное значение для color_Wait. Ожидается строка в формате HEX.');
      return false;
    }
    const duration = Number(arduinoConfig.duration);
    if (isNaN(duration) || duration < 0) {
      errorEmit('Некорректное значение для duration. Ожидается положительное число.');
      return false;
    }
    const reconnectIntervalValue = Number(arduinoConfig.reconnectIntervalValue);
    if (isNaN(reconnectIntervalValue) || reconnectIntervalValue < 0) {
      errorEmit('Некорректное значение для reconnectInterval. Ожидается положительное число.');
      return false;
    }
    return true;
  };

  module.exports = { checkArduinoConfig };