const arduinoLed = require('../index.js');

// const config = require('../configs/neuroFluger.json') // Конфиг Neuro-Fluger
const config = require('../configs/lukoil.json') // Конфиг LUKOIL

let isArduinoConnected = false;
// Подключение к устройству Arduino
const arduinoLedConnect = () => {
    if (config.ledArduino.value.enable.value) {
        try {
            // Neuro-Fluger Локальные значения цветов и других параметров
            // const ledArduino = {
            //     project: config?.ledArduino?.value?.project?.value, // Название проекта
            //     port: config?.ledArduino?.value?.port?.value, // Пример порта, замените на фактический
            //     color_Wait: config?.ledArduino?.value?.color_Wait?.value, // Локальное значение цвета для режима ожидания
            //     brightness: config?.ledArduino?.value?.brightness?.value, // Локальное значение яркости
            //     duration: config?.ledArduino?.value?.duration?.value, // Локальное задержки
            //     numLeds: config?.ledArduino?.value?.number_LED?.value, // Локальное значение количества LEDs
            //     reconnectIntervalValue: config?.ledArduino?.value?.reconnect_Interval_Value?.value // Локальное значение интервала переподключения
            // }

            // LUKOIL Локальные значения цветов и других параметров
            const ledArduino = {
                project: config?.ledArduino?.value?.project?.value, // Название проекта
                port: config?.ledArduino?.value?.port?.value, // Пример порта, замените на фактический
                idleColor: config?.ledArduino?.value?.idleColor?.value, // Локальное значение цвета для режима ожидания
                enableRGBPin: config?.ledArduino?.value?.enableRGBPin?.value, // Разрешение на использование пинов red green blue
                dataPin: config?.ledArduino?.value?.dataPin?.value, // Локальное значение data на Arduino
                clockPin: config?.ledArduino?.value?.clockPin?.value, // Локальное значение clock на Arduino
                redPin: config?.ledArduino?.value?.redPin?.value, // Локальное значение red на Arduino
                greenPin: config?.ledArduino?.value?.greenPin?.value, // Локальное значение green на Arduino
                bluePin: config?.ledArduino?.value?.bluePin?.value, // Локальное значение blue на Arduino
                reconnectIntervalValue: config?.ledArduino?.value?.reconnect_Interval_Value?.value // Локальное значение интервала переподключения
            }

            console.log('[LED Arduino] Настройки Arduino для работы светодиодной ленты успешно получены: ', ledArduino);

            arduinoLed.connectArduino(ledArduino);

            // Обработка событий
            arduinoLed.on('open', (data) => {
                console.log('[LED Arduino] ', data);   
                isArduinoConnected = true;          
            });

            arduinoLed.on('close', () => {
                console.log('[LED Arduino] Соединение с Arduino разорвано');
                isArduinoConnected = false;
            });

            arduinoLed.on('error', (error) => {
                console.error(`[LED Arduino] Ошибка: ${error}`);
                isArduinoConnected = false;
            });

            arduinoLed.on('data', (data) => {
                console.log(`[LED Arduino] `, data);
            });

            arduinoLed.on('status-changed',(statusObject) => {
                console.log(`[LED Arduino] `,statusObject);
            });
        } catch (error) {
            console.error('[LED Arduino] В работе модуля LED Arduino возникли ошибки:', error);
            isArduinoConnected = false;
        }
    }
};

// Функция отправляет команды в пакет для вызова сценария свечения светодиодной ленты
const callLedArduinoCommand = (commandType, args) => {
    if (isArduinoConnected && arduinoLed) {
        arduinoLed.callCommand(commandType, args);
    } else {
        console.warn(`[devices] Команда ${commandType} не может быть выполнена: Arduino не подключено.`);
    }
};

arduinoLedConnect();

// Отправляем команд с интервалом для Neuro-Fluger
// setInterval(() => { 
//     callLedArduinoCommand('nav', {color:'#60f50a'}); 
// }, 10000);
// setInterval(() => {
//     callLedArduinoCommand('spec', {color: '#ff3064'});  
// }, 20000); 

// Отправляем команды с интервалом для LUKOIL
setTimeout(() => { 
    callLedArduinoCommand('dimmer', {hexColor:'#60f50a', speed: 10}); 
}, 10000);
setTimeout(() => {
    callLedArduinoCommand('blink', {hexColor: '#FF3064', hexColor2: '#60F50A', speed: 50});  
}, 20000); 
setTimeout(() => {
    callLedArduinoCommand('smoothtransition', {hexColor: '#00ff00', hexColor2: '#FFFF00', speed: 10});  
}, 30000); 
setTimeout(() => { 
    callLedArduinoCommand('staticlighting', {hexColor:'#60f50a'}); 
}, 40000);
setTimeout(() => { 
    callLedArduinoCommand('pulse', {hexColor:'#FF0000', duration: 10}); 
}, 50000);