const { errorEmit, dataEmit, connectEmit, disconnectEmit, statusChangedEmit } = require('../events');

// Функция для отправки команды «configData({brightness}, {numLeds}, {arduino})»
const sendConfigInitializeCommand = (brightness, numLeds, arduino) => {
    if (arduino && arduino.isOpen) {
      const configDataCommand = `configData (${brightness}, ${numLeds})`;
      arduino.write(configDataCommand, (error) => {
        if (error) {
          errorEmit(`Ошибка при отправке команды configData: ${error.message}`);
        } else {
          dataEmit(`Отправлена команда configData с параметрами: яркость — ${brightness}, количество LEDs — ${numLeds}`);
        }
      });
    } else {
      errorEmit('Arduino порт не открыт. Пожалуйста, подключитесь к порту перед отправкой команды configData.');
      return false
    }
  };

  // Функция для отправки команды для включения ждущего режима
  const sendInitializeHEXCommand = async (hexColor, duration, arduino) => {
    if (arduino && arduino.isOpen) {
      const initializeCommand = `init(${hexColor}) (${duration})`;
      const commandArray = initializeCommand.split(' ');
  
      for (let index = 0; index < commandArray.length; index++) {
        await new Promise((resolve) => {
          arduino.write(commandArray[index], (error) => {
            if (error) {
              errorEmit(`Ошибка при отправке символа: ${error.message}`);
              resolve();
            } else {
              setTimeout(resolve, 1); // Задержка в 10 миллисекунд между символами
            }
          });
        });
      };
      await new Promise((resolve) => {
        arduino.write('\n', (error) => {
          if (error) {
            errorEmit(`Ошибка при отправке символа новой строки: ${error.message}`);
          }
          setTimeout(resolve, 0); // Задержка после последнего символа
        });
      });
      dataEmit(`Включен ждущий режим: цвет — ${hexColor}, с задержкой — ${duration}`);
    } else {
      errorEmit('Arduino порт не открыт. Пожалуйста, подключитесь к порту перед отправкой команды init({hexColor}, {numLeds}).',);
      return false
    }
  };

  const sendCommand = (commandType, hexColor, arduino) => { // spec nav
    if (arduino && arduino.isOpen) {
      const command = `${commandType}(${hexColor})`;
      arduino.write(command, (error) => {
        if (error) {
          errorEmit(`Ошибка при отправке команды: ${error.message}`);
        } else {
          dataEmit(`Отправлена команда: тип — ${commandType}, цвет — ${hexColor}`);
        }
      });
    } else {
      errorEmit(`Arduino порт не открыт. Пожалуйста, подключитесь к порту перед отправкой команды ${commandType}({hexColor}).`);
      return false
    }
  };

  module.exports = {
    sendConfigInitializeCommand,
    sendInitializeHEXCommand,
    sendCommand
  }