(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "triple-beam", "winston"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const triple_beam_1 = require("triple-beam");
    const winston = require("winston");
    const statisticFormat = winston.format((info) => {
        const obj = JSON.parse(info.message);
        const beginDate = new Date(obj.data.data.cheque.beginDate);
        let fuelPrice = 0;
        let cafePrice = 0;
        obj.data.data.cheque.lines.forEach((item) => {
            var _a;
            if (item.nozzle === null)
                cafePrice += item.payments[0].amountPayment;
            if ((_a = item.nozzle) === null || _a === void 0 ? void 0 : _a.id) {
                fuelPrice += item.payments[0].amountPayment;
            }
        });
        info[triple_beam_1.MESSAGE] = `${beginDate.getHours()}:${beginDate.getMinutes()}:${beginDate.getSeconds()}\t${(+new Date(obj.data.data.cheque.printDate) - +beginDate) / 1000}\t${cafePrice}\t${fuelPrice}\t${obj.data.data.cheque.amountPayment}`;
        return info;
    })();
    exports.default = statisticFormat;
});
