(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "winston", "./formats/statistics-format", "./transports/transports", "winston", "dayjs"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loggerMessage = exports.loggerStatistic = exports.infoLogger = exports.logger = void 0;
    const winston = require("winston");
    const statistics_format_1 = require("./formats/statistics-format");
    const transports_1 = require("./transports/transports");
    const winston_1 = require("winston");
    const dayjs = require("dayjs");
    const { combine, timestamp } = winston.format;
    const logger = winston.createLogger({
        levels: {
            error: 1,
            debug: 2,
        },
        format: timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss:ms',
        }),
        transports: [transports_1.errorTransport, transports_1.debugTransport],
    });
    exports.logger = logger;
    const infoLogger = winston.createLogger({
        levels: {
            info: 1,
        },
        format: timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss:ms',
        }),
        transports: [transports_1.infoTransport],
    });
    exports.infoLogger = infoLogger;
    const loggerStatistic = winston.createLogger({
        levels: {
            statistics: 1,
        },
        format: combine(timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss:ms',
        }), statistics_format_1.default),
        transports: [transports_1.statisticsTransport],
    });
    exports.loggerStatistic = loggerStatistic;
    const loggerMessage = winston.createLogger({
        levels: {
            message: 1,
        },
        format: combine(timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss:ms',
        }), winston_1.format.printf((args) => {
            return `${args.message}|${dayjs(args.timestamp).format('HH:mm')}`;
        })),
        transports: [transports_1.messagesTransport],
    });
    exports.loggerMessage = loggerMessage;
});
