interface Price {
    value: string;
}
interface Product {
    id: number;
    externalId: number;
    name: string;
    shortName: string;
    price: Price;
    productType: string;
    zone: number;
}
interface ProductGroup {
    id: number;
    name: string;
    groupType: string;
    products: Product[];
}
interface MenuData {
    productGroups: ProductGroup[];
    needFuellingPoint: boolean;
    fpPosition: number;
    fpOnlyPostPay: boolean;
    canSaleByBarcode: boolean;
}
interface Picture {
    id: number;
    type: number;
    hash: string;
    data: ArrayBuffer;
    extension: string;
}
interface ImagesDataAll {
    msgType: 'imagesDataAll';
    pictures: Picture[];
}
interface Pos {
    id: number;
    name: string;
}
interface DataSettings {
    pos: Pos;
}
interface settingsDataStructure {
    msgType: 'stationConfig';
    data: DataSettings;
}
interface Nozzle {
    id: number;
    tankId: number;
}
interface FuelPoint {
    id: number;
    nozzles: Nozzle[];
    number: number;
}
interface ProductFuel {
    id: number;
    displayName: string;
    name: string;
    price: number;
}
interface TankProduct {
    product: ProductFuel;
    tankId: number;
}
interface FuelStationData {
    msgType: 'fpConfig';
    fps: FuelPoint[];
    tankProducts: TankProduct[];
}
interface ObjectFuelStation {
    fps: FuelPoint[];
    tankProducts: TankProduct[];
}
interface CafeData {
    cafeBeeper: number;
    infoWindowTimeout: number;
    timeoutInfo: number;
    timeoutShortInfo: number;
    timeoutUserOperation: number;
    timeoutWaitQuestion: number;
}
interface OptionsDataStructure {
    msgType: 'optionsUpdate';
    data: CafeData;
}
interface FpStatusMessage {
    msgType: 'fpStatus';
    data: FpStatusData;
}
interface FpStatusData {
    fpId: number;
    lockId: number;
    logicalNozzleId: number;
    physicalNozzleId: number;
    extChequeId: number;
    extChequeLineId: number;
    moneyPlan: number;
    moneyFact: number;
    volumePlan: number;
    volumeFact: number;
    unpaid: boolean;
    mainState: 0 | 1 | 2 | 3 | 4 | 5;
}
interface BasketLine {
    id: number;
    inputType: number;
    nozzle: {
        id: number;
    } | null;
    price: number;
    product: {
        id: number;
        name: string;
        price: number;
        barCode: string;
        code: string;
        longName: string;
        shortName: string;
    };
    quantityFact: number;
    quantityPlan: number;
}
interface Cheque {
    id: number;
    qrCode: string;
    lines: BasketLine[];
}
interface BasketUpdateData {
    basketState: number;
    cheque: Cheque;
}
interface BasketUpdateMessage {
    msgType: 'basketUpdate';
    data: BasketUpdateData;
}
interface AddFuelLine {
    msgType: 'addFuelLine';
    cmdId: string;
    data: boolean;
}
interface AddPostPayFuel {
    msgType: 'addPostpayFuel';
    cmdId: string;
    data: boolean;
}
interface AddProductLine {
    msgType: 'addProductLine';
    cmdId: string;
    data: boolean;
}
interface AddProductLineByBarCode {
    msgType: 'addProductLineByBarCode';
    cmdId: string;
    data: string | null;
}
interface AcceptOrderUpdateData {
    clientPhoneNumber: number;
    beeperNumber: number;
    takeAway: boolean;
}
interface AddAcceptOrder {
    msgType: 'acceptOrder';
    cmdId: string;
    data: AcceptOrderUpdateData;
}
interface AnswerAddAcceptOrder {
    msgType: 'acceptOrder';
    data: string;
}
interface AnswerShowMessage {
    msgType: 'showMessage';
    data: string;
}
interface AnswerServiceUnavailable {
    msgType: 'serviceUnavailable';
    data: string;
}
interface AnswerServiceAvailable {
    msgType: 'serviceAvailable';
    data: string;
}
interface AnswerConnected {
    msgType: 'connected';
    cmdId: string;
    data: boolean;
}
interface IFpLock {
    msgType: 'fpLock';
    cmdId: string;
    data: boolean;
}
interface ButtonRequestCallback {
    name: string;
    default: boolean;
    text: string;
}
interface AddRequestCallback {
    msgType: 'requestCallback';
    cmdId: string;
    data: {
        buttons: ButtonRequestCallback[];
        closeButton: ButtonRequestCallback;
        controls: Array<any>;
        keyboard: null;
        message: string;
        mode: number;
        requestId: number;
        showOnForeground: boolean;
        title: string;
        withSound: boolean;
    };
}
interface AddLoyaltyOtpCode {
    msgType: 'loyaltyOtpCode';
    cmdId: string;
    data: string;
}
interface AddСallbackClientData {
    msgType: 'callbackClientData';
    cmdId: string;
    data: {
        idClient: string;
        clientName: string;
        availablePoints: number;
    };
}
interface AddResendOtpTimerValue {
    msgType: 'resendOtpTimerValue';
    cmdId: string;
    data: number;
}
interface AddShowMessageWindow {
    msgType: 'showMessageWindow';
    data: string;
}
interface DataModule {
    menuCafeServiceData: null | MenuData;
    imagesDataAllData: null | Picture[];
    settingsDataStructureData: null | DataSettings;
    fuelStationDataData: null | ObjectFuelStation;
    optionsDataStructureData: null | CafeData;
    informationMessageFromKSO: string;
    remainingTimeValue: number;
    confirmationPointsDebiting: string;
    answerButtons: {
        msgType: string;
        cmdId: string;
        data: {
            buttons: ButtonRequestCallback[];
            closeButton: ButtonRequestCallback;
            controls: Array<any>;
            keyboard: null;
            message: string;
            mode: number;
            requestId: number;
            showOnForeground: boolean;
            title: string;
            withSound: boolean;
        };
    } | null;
    arrStateTRK: FpStatusData[];
    acceptOrderValue: boolean;
    valueFuel: null | number;
    basketValue: null | BasketUpdateData;
    idClient: null | string;
    clientData: null | AddСallbackClientData['data'];
}
type dataAddProductLine = {
    productId: number;
    price: number;
    inputType: number;
};
type addProductLine = {
    msgType: 'addProductLine';
    cmdId: string;
    data: dataAddProductLine;
};
export type { DataModule, ImagesDataAll, settingsDataStructure, FuelStationData, OptionsDataStructure, FpStatusMessage, FpStatusData, BasketUpdateMessage, AddFuelLine, AddPostPayFuel, addProductLine, AddProductLine, AddAcceptOrder, AddProductLineByBarCode, AnswerAddAcceptOrder, AnswerShowMessage, AddRequestCallback, AddLoyaltyOtpCode, AddResendOtpTimerValue, AddShowMessageWindow, AnswerServiceUnavailable, AnswerServiceAvailable, AnswerConnected, AddСallbackClientData, IFpLock, };
