const { app, BrowserWindow, screen } = require('electron');

require('electron-reloader')(module);

const createWindow = (size) => {
  try {
    const window = new BrowserWindow({
      webPreferences: {
        nodeIntegration: true, // позволяет использовать функции Node.js в процессе отображения
        contextIsolation: false,
      },
      id: 'main',
      width: 1920,
      height: 1080,
      x: 0,
      y: 0,
      // frame: false, //отключение верхней навигационной панели
      fullScreen: true,
    });
    window.webContents.openDevTools();
    window.loadFile('index.html');
  } catch (error) {
    console.error('[error] Can not create window. Error:', error);
  }
};

app.whenReady().then(() => {
  const mainScreen = screen.getPrimaryDisplay();
  createWindow(mainScreen.size);
});
