import { MESSAGE } from 'triple-beam';
import winston = require('winston');

import { BasketUpdate } from '../../type';

const statisticFormat = winston.format((info) => {
  const obj: { data: BasketUpdate; timestamp: string } = JSON.parse(info.message);
  const beginDate = new Date(obj.data.data.cheque.beginDate);

  let fuelPrice = 0;
  let cafePrice = 0;

  obj.data.data.cheque.lines.forEach((item) => {
    if (item.nozzle === null) cafePrice += item.payments[0].amountPayment;

    if (item.nozzle?.id) {
      fuelPrice += item.payments[0].amountPayment;
    }
  });

  info[
    MESSAGE
  ] = `${beginDate.getHours()}:${beginDate.getMinutes()}:${beginDate.getSeconds()}\t${
    (+new Date(obj.data.data.cheque.printDate) - +beginDate) / 1000
  }\t${cafePrice}\t${fuelPrice}\t${obj.data.data.cheque.amountPayment}`;

  return info;
})();

export default statisticFormat;
