const moment = require('moment');
const log = require('electron-log');

const reboot = require('../modules/reboot');

let lastUnixMsTime = null;

const timeIsOffset = (interval = 1000, maxDifference = 1000) => {
    try {
        const nowMoment = moment();
        const nowMs = nowMoment.format('x');
        const difference = nowMs - lastUnixMsTime;
        const currentDiff = difference - interval;

        if ( lastUnixMsTime && (currentDiff > maxDifference || currentDiff < -maxDifference) ) {
            if ( process.platform === 'linux' ) {
                log.warn('time updated, init restart app');
                reboot.roskomnadzor();
            }
        }

        lastUnixMsTime = nowMs;
    } catch (e) {
        log.error('timeIsOffset\n', e);
    }
};

module.exports = timeIsOffset;
