const log = require('electron-log');

const devToolsAutoClose = (win) => {
    try {
        const pause = 1000 * 60 * 15;
        let timeoutId = null;

        win.webContents.on('devtools-opened', function () {
            // log.info('auto close dev-tools after: '+ (pause / 1000 / 60) +' minutes.');

            clearTimeout(timeoutId);

            timeoutId = setTimeout(() => {
                log.info('devTools auto-closed');

                win.webContents.closeDevTools();
            }, pause);
        });
    } catch (err) {
        log.error('helper:devToolsAutoClose broken', err);
    }
};

module.exports = devToolsAutoClose;