const {app, remote} = require('electron');
const path = require('path');
const fs = require('fs');
const log = require('electron-log');

const removeItem = (itemPath) => {
    try {
        const itemFullPath = path.join(app.getPath('userData'), itemPath);

        if ( fs.existsSync(itemFullPath) ) {
            fs.unlinkSync(itemFullPath);

            log.info(`item: ${itemPath} removed`);

            return true;
        } else {
            log.warn(`item for remove: ${itemPath} not found`);

            return false;
        }
    } catch (e) {
        log.error('mod:content-loader/remove-item', e);
    }
};

module.exports = removeItem;