const log = require('electron-log');
const path = require('path');

const popup = require('../popup');

const playlist = (blocksStartTime, contentStartTime, updatePlayedInfo) => {
    try {
        const playlistBody = popup.elem.querySelector('.js-info-popup__playlist-body');

        playlistBody.style.display = 'none';
        playlistBody.innerHTML = '';

        blocksStartTime.forEach((blockTime, blockIndex) => {
            const scenarios = contentStartTime[blockIndex];
            const block = document.createElement('div');
            const cellIndex = document.createElement('div');
            const scenariosRow = document.createElement('div');
            const scenarioBlock = document.createElement('div');

            cellIndex.classList.add('row__cell');
            cellIndex.innerHTML = String(blockIndex);

            // scenariosRow.classList.add('row', 'row_nowrap');
            scenarioBlock.classList.add('info-popup-playlist__scenario');

            scenarios.forEach((content) => {
                const contentRow = getContentRow(content);

                scenarioBlock.appendChild(contentRow);
            });

            scenariosRow.appendChild(scenarioBlock);

            block.appendChild(cellIndex);

            playlistBody.appendChild(block);
            playlistBody.appendChild(scenariosRow);
        });

        updatePlayedInfo();

        playlistBody.style.display = '';
    } catch (e) {
        log.error('Error: info-popup/playlist/create-elems playlist()', e);
    }
};

const getContentRow = (content) => {
    try {
        const row = document.createElement('div');
        const contentStartTimePlain = getElem(content.startTimePlain, ['row__cell', 'nowrap']);
        const contentDurationMs = getElem(`${content.durationMs / 1000} sec.`, ['row__cell', 'nowrap']);
        const contentFilePath = getFileNameCellElem(content.filePath);

        row.classList.add('row', 'row_nowrap');
        row.dataset.contentId = content.id;
        row.dataset.contentStartTime = content.startTime;

        row.appendChild(contentStartTimePlain);
        row.appendChild(contentDurationMs);
        row.appendChild(contentFilePath);

        return row;
    } catch (e) {
        log.error('Error: info-popup/playlist/create-elems getContentRow()', e);
    }
};

const getFileNameCellElem = (filePath) => {
    try {
        const fileName = path.parse(filePath).name + path.parse(filePath).ext;
        const contentFilePath = getElem('', ['row__cell', 'row', 'row_nowrap', 'info-popup-playlist__filename'], fileName);
        const contentFilePathInner = getElem(fileName, ['row__cell', 'info-popup-playlist__filename-inner']);

        contentFilePath.appendChild(contentFilePathInner);

        return contentFilePath;
    } catch (e) {
        log.error('Error: info-popup/playlist/create-elems getFileNameCellElem()', e);
    }
};

const getElem = (value, classes, title) => {
    try {
        const elem = document.createElement('div');

        elem.innerHTML = (value || value === 0 ? value : '');

        if ( classes && typeof classes === 'object' && classes.length > 0 ) {
            classes.forEach((cls) => elem.classList.add(cls));
        }

        if ( title || title === 0 ) {
            elem.title = title;
        }

        return elem;
    } catch (e) {
        log.error('Error: info-popup/playlist/create-elems getElem()', e);
    }
};

module.exports = {
    playlist,
};
