const log = require('electron-log');

let popup = null;

const init = () => {
    if (popup) {
        return;
    }

    const template = document.body.querySelector('.info-popup-template');
    const templateCopy = template.content.children[0].cloneNode(true);

    popup = document.body.appendChild(templateCopy);
};

const isHiddenPopup = () => !(popup?.classList.contains('info-popup_show'));

const toggle = () => {
    try {
        init();

        popup.classList.toggle('info-popup_show');

        if ( !isHiddenPopup() ) {
            document.dispatchEvent(new Event('info-popup.afterShow'));
        }
    } catch (e) {
        log.error('Error: info-popup toggle()', e);
    }
};

module.exports = {
    elem: popup,
    isHiddenPopup,
    toggle,
};
