const app = require('electron').app || require('electron').remote.app;
const path = require('path');
const fs = require('fs');
const log = require('electron-log');
const moment = require('moment');
const isDev = require('electron-is-dev');

const loggerDirName = 'logger';

module.exports.init = function () {
    try {
        const logsPath = path.join(app.getPath('userData'), loggerDirName);
        const toDayLogsPath = path.join(logsPath, moment().format('YYYY.MM.DD'));

        if ( !fs.existsSync(app.getPath('userData')) ) {
            fs.mkdirSync(app.getPath('userData'));
        }

        if ( !fs.existsSync(logsPath) ) {
            fs.mkdirSync(logsPath);
        }

        if ( !fs.existsSync(toDayLogsPath) ) {
            fs.mkdirSync(toDayLogsPath);
        }

        let fileName = moment().format('HH.mm');
        fileName += '.log';

        if ( isDev ) {
            log.transports.console.format = '[{h}:{i}:{s}.{ms}]\n{text}';
            log.transports.console.level = 'silly';
            log.transports.console.forceStyles = true;
        } else {
            log.transports.console = false;
        }

        log.transports.file.fileName = fileName;
        log.transports.file.format = '[{y}-{m}-{d} {h}:{i}:{s}.{ms}] [{level}] {text}';
        log.transports.file.level = 'silly';
        log.transports.file.maxSize = 0;
        log.transports.file.file = path.join(toDayLogsPath, log.transports.file.fileName);
    } catch (err) {
        log.error(`mod:logger:init()`, err);
    }
};
