const log = require('electron-log');

module.exports = (task) => {
    try {
        if ( task.schedule_day_start === task.schedule_day_end ) {
            return [ true, true, true, true, true, true, true ];
        }

        const allowDaysArr = [
            false,
            false,
            false,
            false,
            false,
            false,
            false
        ];
        const start = (task.schedule_day_start < task.schedule_day_end ? task.schedule_day_start : task.schedule_day_end);
        const end = (task.schedule_day_start > task.schedule_day_end ? task.schedule_day_start : task.schedule_day_end);

        for ( let i = start; i <= end; i++ ) {
            allowDaysArr[i] = true;
        }

        return allowDaysArr;
    } catch (err) {
        log.error('scheduler:get-allow-days', err);
    }
};
