const log = require('electron-log');

const promiseTimeout = (promise, delayMs = 25) => {
    return new Promise(function(resolve, reject) {
        try {
            if ( !promise ) {
                return reject(new Error('mod:timeout-for-promise: not send promise'));
            }

            const timeout = setTimeout(() => {
                reject(new Error("mod:timeout-for-promise: rejected by timeout"));
            }, delayMs * 1000);

            promise.then(resolve, reject).then(() => clearTimeout(timeout));
        } catch (e) {
            reject(log.error('mod:timeout-for-promise broken', e));
        }
    });
};

module.exports = promiseTimeout;

