const colors = Object.freeze({
    default: 39,
    black: 30,
    red: 31,
    green: 32,
    yellow: 33,
    blue: 34,
    magenta: 35,
    cyan: 36,
    lightGray: 37,
    darkGray: 90,
    lightRed: 91,
    lightGreen: 92,
    lightYellow: 93,
    lightBlue: 94,
    lightMagenta: 95,
    lightCyan: 96,
    whiteCyan: 97
});
const excapeAnsiCode = (code) => '\x1b[' + code + 'm';

const custom = (text, colorName) => {
    const colorNumber = (colors[colorName] || colors.default);
    const colorCode = excapeAnsiCode(colorNumber);

    console.log('%s%s%s', colorCode, text, '\x1b[0m');
};

const exception = (fn, varInObject, mustBy) => {
    const varName = Object.keys(varInObject)[0];
    const varValue = Object.values(varInObject)[0];
    let text = 'mongo-backuper [Exception]';

    text += ` in ${fn.name}() parameter "${varName}" get incorrect value "${varValue}"\n`;
    text += `"${varName}" ${mustBy}`;

    custom(text, 'yellow');
};

const success = (text) => custom(text, 'green');
const warn = (text) => custom(text, 'yellow');
const error = (text) => custom(text, 'red');

module.exports = {
    custom,
    exception,
    success,
    warn,
    error
};
