const path = require('path');
const fs = require('fs');

const echo = require('../console/echo.js');

const removeDir = (dirPath) => {
    fs.rmdir(dirPath, { recursive: true }, (error) => {
        if (error) {
            echo.warn(error.message);

            return;
        }

        const { dir, name } = path.parse(dirPath);

        echo.success(`${path.sep + name + path.sep}** removed from ${dir} `);
    });
};

module.exports = removeDir;
