/**
 *
 * @param {number} bytes
 * @returns {string}
 */
const getAppropriateSizeFromBytes = (bytes) => {
    const sizeKb = bytes / 1024;
    const sizeMb = sizeKb / 1024;
    const sizeGb = sizeMb / 1024;
    let result = '';

    if (sizeGb >= 1) {
        result += `${sizeGb.toFixed(2)} Gb`;
    } else if (sizeMb >= 1) {
        result += `${sizeMb.toFixed(2)} Mb`;
    } else if (sizeKb >= 1) {
        result += `${sizeKb.toFixed(2)} Kb`;
    } else {
        result += `${bytes} bytes`;
    }

    return result;
};

module.exports = getAppropriateSizeFromBytes;
