const os = require('os');

class Net {
    getIPv4() {
        try {
            return os.networkInterfaces().Ethernet.find((item) => item.family === 'IPv4');
        } catch (err) {
            return {
                address: '',
                mac: ''
            };
        }
    }

    get ip() {
        return this.getIPv4().address || '';
    }

    get mac() {
        return this.getIPv4().mac || '';
    }
}

module.exports = new Net();
