const Application = require('spectron').Application;
const chai = require('chai');
const {assert} = require('chai');
const chaiAsPromised = require('chai-as-promised');
const moment = require('moment');

chai.use(chaiAsPromised);

const scheduler = require('../src/modules/scheduler');
const getAllowDays = require('../src/modules/scheduler/get-allow-days');
const getTimes = require('../src/modules/scheduler/get-times');
const getNextRunDatetime = require('../src/modules/scheduler/get-next-run-datetime');

const tasks = {
    "volume":0,
    "schedules": [{
        "_id":"5c00dc459815bf56b619c6f1",
        "schedule_name":"reload",
        "schedule_type":"reboot",
        "schedule_day_start":"0",
        "schedule_day_end":"6",
        "schedule_time_start":"11:00",
        "createdAt":"2018-11-30T06:44:21.557Z",
        "updatedAt":"2018-12-01T15:17:10.245Z",
        "__v":0,
        "schedule_groups":null,
        "id":"5c00dc459815bf56b619c6f1"
    }, {
        "_id":"5c025b739815bf56b619c96e",
        "schedule_name":"Обновление ПО",
        "schedule_type":"update_app",
        "schedule_day_start":"0",
        "schedule_day_end":"0",
        "schedule_time_start":"09:10",
        "createdAt":"2018-12-01T09:59:15.764Z",
        "updatedAt":"2018-12-07T06:09:01.384Z",
        "__v":0,
        "schedule_groups":null,
        "id":"5c025b739815bf56b619c96e"
    }, {
        "_id":"5c07c2b09815bf56b619caa5",
        "schedule_name":"update buttons",
        "schedule_type":"update_btn",
        "schedule_day_start":"0",
        "schedule_day_end":"6",
        "schedule_time_start":"18:34",
        "createdAt":"2018-12-05T12:21:04.572Z",
        "updatedAt":"2018-12-05T15:31:41.302Z",
        "__v":0,
        "schedule_groups":null,
        "id":"5c07c2b09815bf56b619caa5"
    }]
};

describe('scheduler', () => {
    describe('getAllowDays', () => {
        const rightResultAll = [ true, true, true, true, true, true, true ];
        const rightResult = [ false, false, false, false, false, false, false ];
        for (let i = 0; i < 7; i++) {
            const task = {
                "schedule_day_start": "0",
                "schedule_day_end": `${i}`,
            };
            it(`start: 0; end: ${i}`, () => {
                rightResult[i] = true;
                assert.deepEqual(getAllowDays(task), (i === 0 ? rightResultAll : rightResult));
            });
        }
    });

    describe('getNextRunDatetime', () => {
        for (let i = 0; i < 24; i++) {
            const HH = (String(i).length === 1 ? '0'+ i : i);
            const expectedDay = () => {
                if (HH > moment().format('HH')) {
                    return moment().format('DD');
                } else {
                    return moment().add(1, 'day').format('DD');
                }
            };
            const task = {
                "schedule_day_start":"0",
                "schedule_day_end":"0",
                "schedule_time_start":`${HH}:00`
            };
            const allowDaysArr = [ true, true, true, true, true, true, true ];
            const fnResult = getNextRunDatetime(task, allowDaysArr);
            const timeResult = moment(fnResult * 1000).format('DD-MM-YYYY HH:mm:ss');
            const expectedResult = `${expectedDay()}-12-2018 ${HH}:00:00`;
            it(`${expectedResult}`, () => {
                assert.equal(timeResult, expectedResult);
            });
        }
    });

    /*describe('getTimes', () => {
        const task = {
            "schedule_day_start":"0",
            "schedule_day_end":"0",
            "schedule_time_start":"11:00"
        };
        const result = {};
        result.startAt = moment(task.schedule_time_start, 'HH:mm');
        result.diff = Math.round(result.startAt.diff(moment()) / 1000);
        result.startDate = result.startAt.toDate();
        result.allowDays = getAllowDays(task);
        result.nextRunDatetime = getNextRunDatetime(task, result.allowDays);
        it(`gett`, () => {
            assert.deepEqual(getTimes(task), result);
        });
    });*/
});
