// Создание нового WebSocket подключения к серверу
let ws = new WebSocket("ws://localhost:8003/ws");

// Обработчик события открытия WebSocket соединения
ws.onopen = function() {
    console.log("WebSocket connection opened");
    sendCommand('readFileList'); // Отправка команды для чтения списка файлов при подключении
    sendCommand('readPlayList'); // Отправка команды для чтения списка плейлистов при подключении
    sendCommand('readCurrentPlayList'); // Отправка команды для чтения текущего плейлиста при подключении
    sendCommand('readCurrentVideo'); // Отправка команды для чтения текущего воспроизводимого видео при подключении
};
// Объявление глобальных переменных
let fullVideoList = []; // Полный список видеофайлов
let playlistItemsMap = {}; // Карта для хранения видео по плейлистам
let currentPlaylistIndex = null; // Индекс текущего плейлиста

// Переменная для хранения предыдущего списка плейлистов
let previousPlaylists = [];

ws.onmessage = function(event) {
    console.log("Сообщение от сервера: ", event.data);

    // Обработка сообщений с элементами плейлиста
    if (event.data.startsWith("{\"method\":\"playlistItems\"")) {
        const parsedData = JSON.parse(event.data); // Парсинг данных
        const playlistItems = parsedData.videoList.map(video => video.fileName);
        console.log("Извлеченные элементы плейлиста: ", playlistItems);

        // Обновляем карту плейлистов
        const playlistIndex = currentPlaylistIndex;
        playlistItemsMap[playlistIndex] = playlistItems;

        // Обновление списка элементов плейлиста в UI
        updatePlaylistItemsList(playlistItems);

    // Обработка сообщений со списком файлов
    } else if (event.data.startsWith("fileList:")) {
        const rawData = event.data.substring(9);
        console.log("Сырые данные списка файлов: ", rawData);

        // Попробуем сначала обработать как JSON
        try {
            const parsedData = JSON.parse(rawData);
            if (Array.isArray(parsedData.videoList)) {
                fullVideoList = parsedData.videoList.map(file => file.fileName);
                console.log("Извлеченные файлы из JSON: ", fullVideoList);
                updateFileList(fullVideoList);
                updateLoopVideoList(fullVideoList);
                return;
            }
        } catch (error) {
            console.log("Не удалось разобрать как JSON: ", error);
        }

        // Если это не JSON, продолжаем старую логику обработки данных
        let files = [];

        if (rawData.includes(';')) {
            // Обработка правильного формата
            files = rawData.split(';').map(file => file.trim()).filter(file => file.endsWith('.mp4'));
        } else {
            // Обработка неправильного формата
            files = rawData.split(',').map(file => file.trim()).filter(file => file.endsWith('.mp4'));
        }

        // Обновление полного списка видеофайлов
        fullVideoList = files;
        console.log("Извлеченные файлы: ", files);
        updateFileList(files);
        // updateLoopVideoList(files);

    // Обработка сообщений со списком плейлистов
    } else if (event.data.startsWith("playList:")) {
        const rawData = event.data.substring(9);
        console.log("Сырые данные плейлиста: ", rawData);
        const playlists = rawData.split(';');
        console.log("Извлеченные плейлисты: ", playlists);

        // Сравниваем новый список плейлистов с предыдущим
        if (JSON.stringify(playlists) !== JSON.stringify(previousPlaylists)) {
            console.log("Плейлисты изменились, обновляем...");
            previousPlaylists = playlists; // Обновляем предыдущий список плейлистов

            // Обновляем список плейлистов в UI
            updatePlaylistList(playlists);

            // Загружаем все плейлисты только если они изменились
            loadAllPlaylists(playlists);

            // После получения списка плейлистов, получаем элементы текущего плейлиста
            if (currentPlaylistIndex !== null) {
                sendCommand('usePlayList', currentPlaylistIndex);
                sendCommand('readPlayListItems', currentPlaylistIndex);
            }
        } else {
            console.log("Плейлисты не изменились, никаких действий не требуется.");
        }

    // Обработка сообщений с текущим плейлистом
    } else if (event.data.startsWith("currentPlayList:")) {
        currentPlaylistIndex = parseInt(event.data.substring(17));
        console.log("Индекс текущего плейлиста: ", currentPlaylistIndex);

        // После получения текущего плейлиста, загружаем его элементы
        sendCommand('usePlayList', currentPlaylistIndex);
        sendCommand('readPlayListItems', currentPlaylistIndex);

    // Обработка сообщений с текущим воспроизводимым видео
    } else if (event.data.startsWith("currentVideo:")) {
        const currentVideoData = event.data.substring(13).split(';');
        const currentVideoIndex = parseInt(currentVideoData[0]);
        const currentVideoName = currentVideoData[1];
        console.log("Индекс текущего видео: ", currentVideoIndex, " Название текущего видео: ", currentVideoName);

    // Обработка сообщений об успешной загрузке файла
    } else if (event.data.startsWith("uploadSuccess")) {
        sendCommand('readFileList'); // Обновление списка файлов после успешной загрузки
    }
};



ws.onclose = function() {
    console.log("Соединение WebSocket закрыто");
};

ws.onerror = function(error) {
    console.log("Ошибка WebSocket: ", error);
};

/**
 * Эта функция инициализирует индексы плейлистов и загружает списки плейлистов для корректного вывода видео по названию.
 * @param {Array} playlists - Массив с именами плейлистов.
 */
function loadAllPlaylists(playlists) {
    // Проходимся по каждому плейлисту и загружаем его элементы с задержкой в 1 секунду
    playlists.forEach((playlist, index) => {
        setTimeout(() => {
            currentPlaylistIndex = index;
            console.log("Загрузка плейлиста по индексу: ", index);
            sendCommand('usePlayList', index); // Команда на использование плейлиста
            sendCommand('readPlayListItems', index); // Команда на чтение элементов плейлиста
        }, index * 500); // Задержка в 1 секунду для последовательной загрузки
    });

    // Установить текущий плейлист после загрузки всех плейлистов
    setTimeout(() => {
        currentPlaylistIndex = 0; // Установить индекс текущего плейлиста на 0 (или другой по умолчанию)
        document.getElementById('playlistSelect').selectedIndex = currentPlaylistIndex; // Обновить селектор плейлиста в UI
        console.log("Установить индекс текущего плейлиста на: ", currentPlaylistIndex);
        sendCommand('readPlayListItems', currentPlaylistIndex); // Команда на чтение элементов текущего плейлиста
    }, playlists.length * 500);
}


// Обработчик события для кнопки "Upload File"
document.getElementById('uploadFileButton').addEventListener('click', function() {
    const files = document.getElementById('fileInput').files; // Получаем выбранные файлы
    const fileArray = []; // Массив для хранения данных о файлах

    // Проходимся по каждому файлу и добавляем его данные в массив
    for (let i = 0; i < files.length; i++) {
        const file = files[i];
        const relativePath = file.webkitRelativePath || file.name; // Получаем относительный путь или имя файла
        const data = {
            fileName: file.name,
            filePath: encodeURIComponent(relativePath) // Кодируем относительный путь файла
        };
        fileArray.push(data); // Добавляем данные о файле в массив
    }

    const jsonCommand = JSON.stringify(fileArray); // Преобразуем массив данных о файлах в JSON
    console.log("Sending files: ", jsonCommand); // Логирование данных перед отправкой
    sendCommand('uploadFile', jsonCommand); // Отправляем команду на загрузку файлов
    sendCommand('readFileList'); // Обновляем список видео после загрузки
});

// Обработчик для кнопки "Set Looping"
// document.getElementById('playLoopVideoButton').addEventListener('click', function() {
//     const selectedLoopVideoIndex = document.getElementById('loopVideoSelect').selectedIndex;
//     const repeatValue = document.getElementById('repeatValue').value;
//     sendCommand('setLooping', JSON.stringify({ looping: true, videoIndex: selectedLoopVideoIndex, repeat: parseInt(repeatValue, 10) }));
// });


// Обработчик для изменения выбранного плейлиста
document.getElementById('playlistSelect').addEventListener('change', function() {
    const selectedPlaylist = this.value;
    currentPlaylistIndex = selectedPlaylist;
    sendCommand('readPlayListItems', selectedPlaylist);
});

// Обработчик нажатия кнопки Load Playlist
document.getElementById('loadPlaylistButton').addEventListener('click', function() {
    const selectedPlaylistIndex = document.getElementById('playlistSelect').selectedIndex;
    currentPlaylistIndex = selectedPlaylistIndex;
    console.log("Загрузка плейлиста с индексом: ", selectedPlaylistIndex);
    sendCommand('usePlayList', selectedPlaylistIndex);
    sendCommand('readPlayListItems', selectedPlaylistIndex);
});

// Обработчик нажатия кнопки Play Video from Playlist
// Когда пользователь нажимает на кнопку "Play Video from Playlist", выполняется эта функция.
document.getElementById('playPlaylistVideoButton').addEventListener('click', () => {
    // Получаем индекс выбранного плейлиста.
    const selectedPlaylistIndex = document.getElementById('playlistSelect').selectedIndex;
    // Получаем индекс выбранного видео в плейлисте.
    const selectedVideoIndex = document.getElementById('playlistItemsSelect').selectedIndex;
    // Логируем выбранные индексы плейлиста и видео в консоль.
    console.log("Индекс выбранного списка воспроизведения:", selectedPlaylistIndex);
    console.log("Указатель избранных видеоматериалов:", selectedVideoIndex);
    // Отправляем команду на воспроизведение видео из выбранного плейлиста.
    sendCommand('playVideoFromPlaylist', { playlistIndex: selectedPlaylistIndex, videoIndex: selectedVideoIndex });
});


// Функция для обновления списка плейлистов
// Эта функция обновляет содержимое выпадающего списка плейлистов.
const updatePlaylistList = (playlists) => {
    const select = document.getElementById('playlistSelect');    // Получаем элемент select для списка плейлистов.
    select.innerHTML = "";    // Очищаем все существующие опции в select.
    // Проходим по каждому плейлисту в списке плейлистов.
    playlists.forEach((playlist, index) => {
        const option = document.createElement('option');        // Создаем новую опцию для select.
        option.value = index;        // Устанавливаем значение опции равным индексу плейлиста.
        option.textContent = playlist;        // Устанавливаем текст опции равным названию плейлиста.
        select.appendChild(option);       // Добавляем опцию в select.
    });

    // Устанавливаем текущий плейлист после загрузки
    if (currentPlaylistIndex !== null) {
        // Устанавливаем значение select в соответствие с текущим индексом плейлиста.
        select.value = currentPlaylistIndex;
    }
};

// Функция для обновления списка видео в плейлисте
// Обновляет содержимое выпадающего списка видео, находящихся в выбранном плейлисте.
const updatePlaylistVideoList = (videos) => {
    const select = document.getElementById('playlistVideoSelect');
    select.innerHTML = ""; // Очистка существующих опций
    videos.forEach((video, index) => {
        const option = document.createElement('option');
        option.value = index;
        option.textContent = video;
        select.appendChild(option);
    });
};

// Функция для загрузки элементов выбранного плейлиста
// Отправляет команду на чтение элементов выбранного плейлиста.
const loadPlaylistItems = () => {
    const selectedPlaylist = document.getElementById('playlistSelect').value;
    sendCommand('readPlayListItems', selectedPlaylist);
};

// Функция для добавления видео в плейлист
// Отправляет команду на добавление выбранного видео в выбранный плейлист.
const addVideoToPlaylist = () => {
    const selectedPlaylist = document.getElementById('playlistSelect').value;
    const selectedVideo = document.getElementById('videoSelect').value;
    if (selectedPlaylist && selectedVideo) {
        sendCommand('addVideoToPlaylist', JSON.stringify({ playlistName: selectedPlaylist, videoFileName: selectedVideo }));
    } else {
        alert('Please select both a playlist and a video.');
    }
};


// Обработчик нажатия кнопки Play Video
// Когда пользователь нажимает на кнопку "Play Video", выполняется эта функция.
document.getElementById('playSelectedVideoButton').addEventListener('click', () => {
    const selectedVideoName = document.getElementById('videoSelect').selectedOptions[0].textContent;
    console.log("Selected video name: ", selectedVideoName);
    playVideoByName(selectedVideoName);
});

// Функция для воспроизведения видео по его названию
// Ищет и воспроизводит видео по заданному названию.
const playVideoByName = (videoName) => {
    console.log("Попытка найти и воспроизвести видео с именем: ", videoName);

    // Ищем видео в текущем плейлисте
    if (currentPlaylistIndex !== null && playlistItemsMap[currentPlaylistIndex]) {
        const videoIndex = playlistItemsMap[currentPlaylistIndex].findIndex(video => video === videoName);
        if (videoIndex !== -1) {
            console.log("Найдено видео в текущем списке воспроизведения. Воспроизведение видео из списка воспроизведения по индексу:", videoIndex);
            sendCommand('playVideoFromPlaylist', { playlistIndex: currentPlaylistIndex, videoIndex: videoIndex });
            return;
        }
    }

    // Ищем видео в других плейлистах
    for (const [playlistIndex, items] of Object.entries(playlistItemsMap)) {
        const videoIndex = items.findIndex(video => video === videoName);
        if (videoIndex !== -1) {
            console.log("Найдено видео в другом плейлисте. Переключение на список и воспроизведение видео по индексу:", videoIndex);
            sendCommand('playVideoFromPlaylist', { playlistIndex: Number(playlistIndex), videoIndex: videoIndex });
            return;
        }
    }

    // Ищем видео в полном списке видео
    const videoIndex = fullVideoList.findIndex(video => video === videoName);
    if (videoIndex !== -1) {
        console.log("Найдено видео в полном списке видео. Воспроизведение видео в индексе:", videoIndex);
        sendCommand('playVideo', videoIndex);
    } else {
        console.log("Видео не найдено в полном списке видео.");
    }
}

// Обработчик нажатия кнопки "Clear All Videos"
// Отправляет команду для очистки всех видео.
document.getElementById('clearAllVideosButton').addEventListener('click', () => {
    sendCommand('clearAllVideos');
});

// Функция для отправки команд через WebSocket
// Создает команду с заданным методом и аргументами, преобразует её в JSON и отправляет через WebSocket.
function sendCommand(method, args) {
    const command = {
        method: method,
        args: typeof args === 'string' ? args : JSON.stringify(args)
    };
    const jsonCommand = JSON.stringify(command);
    console.log("Sending command: ", jsonCommand); // Логирование команды перед отправкой
    ws.send(jsonCommand);
}


// Обработчик нажатия кнопки "Delete Video"
// Отправляет команду для удаления выбранного видео и обновляет список видео.
document.getElementById('deleteVideoButton').addEventListener('click', () => {
    const selectedVideoIndex = document.getElementById('deleteVideoSelect').value;
    sendCommand('deleteVideo', selectedVideoIndex);
    sendCommand('readFileList');
});

// Функция для обновления списка видео для удаления
// Обновляет содержимое выпадающего списка видео, которые могут быть удалены.
const updateDeleteVideoList = (fileList) => {
    const select = document.getElementById('deleteVideoSelect');
    select.innerHTML = ""; // Очистка существующих опций
    fileList.forEach((file, index) => {
        // Добавляем только корректные названия файлов
        if (file.endsWith('.mp4')) { // Проверяем наличие расширения .mp4
            const option = document.createElement('option');
            option.value = index; // Используем индекс видео
            option.textContent = file;
            select.appendChild(option);
        }
    });
}

// Функция для обновления элементов плейлиста
// Эта функция обновляет содержимое выпадающего списка элементов плейлиста.
const updatePlaylistItemsList = (items) => {
    // Получаем элемент select для списка элементов плейлиста.
    const select = document.getElementById('playlistItemsSelect');
    // Очищаем все существующие опции в select.
    select.innerHTML = "";
    // Логируем обновление элементов плейлиста в консоль.
    console.log("Updating playlist items select with: ", items);
    // Проходим по каждому элементу в списке элементов.
    items.forEach((item) => {
        // Создаем новую опцию для select.
        const option = document.createElement('option');
        // Устанавливаем значение опции равным элементу.
        option.value = item;
        // Устанавливаем текст опции равным элементу.
        option.textContent = item;
        // Добавляем опцию в select.
        select.appendChild(option);
    });
};

// Функция для обновления списка видео
// Обновляет содержимое выпадающего списка видео, доступных для воспроизведения.
const updateFileList = (fileList) => {
    const select = document.getElementById('videoSelect');
    select.innerHTML = ""; // Очистка существующих опций
    // console.log("Updating file list with:", fileList);
    fileList.forEach((file, index) => {
        // Добавляем только корректные названия файлов
        if (file.endsWith('.mp4')) { // Проверяем наличие расширения .mp4
            const option = document.createElement('option');
            option.value = index; // Используем индекс видео
            option.textContent = file;
            select.appendChild(option);
            console.log("Added option:", file);
        }
    });
    updateDeleteVideoList(fileList); // Обновление списка для удаления
    console.log("Обновление списка файлов.");
}

// Функция для обновления списка файлов для повторяющегося воспроизведения
// Обновляет содержимое выпадающего списка видео, доступных для установки в режим повтора.
// const updateLoopVideoList = (fileList) => {
//     const select = document.getElementById('loopVideoSelect');
//     select.innerHTML = ""; // Очистка существующих опций
//     fileList.forEach((file, index) => {
//         // Добавляем только корректные названия файлов
//         if (file.endsWith('.mp4')) { // Проверяем наличие расширения .mp4
//             const option = document.createElement('option');
//             option.value = index; // Используем индекс видео
//             option.textContent = file;
//             select.appendChild(option);
//         }
//     });
// }

// Обработчик нажатия кнопки "Create Playlist"
// Отправляет команду для создания нового плейлиста с заданным именем.
document.getElementById('createPlaylistButton').addEventListener('click', () => {
    const playlistName = document.getElementById('newPlaylistName').value;
    if (playlistName) {
        sendCommand('createPlaylist', playlistName);
    } else {
        alert('Пожалуйста, введите имя для списка воспроизведения.');
    }
});

// Обработчик нажатия кнопки "Set Speed"
document.getElementById('setMotorSpeedButton').addEventListener('click', () => {
    const selectedSpeed = document.getElementById('motorSpeedSelect').value;
    sendCommand('setMotorSpeed', selectedSpeed);
});

// Обработчик нажатия кнопки "Set Interval"
// document.getElementById('setVideoIntervalButton').addEventListener('click', () => {
//     const selectedInterval = document.getElementById('videoIntervalInput').value;
//     sendCommand('setSwitchInterval', selectedInterval);
// });

// Обработчик для кнопки "Pause Video"
document.getElementById('pauseVideoButton').addEventListener('click', () => {
    sendCommand('pausePlayer');
});

// Обработчик для кнопки "Resume Video"
document.getElementById('resumeVideoButton').addEventListener('click', () => {
    sendCommand('resumePlayer');
});

// document.getElementById('toggleLoopingButton').addEventListener('click', () => {
//     const repeatValue = document.getElementById('repeatValue').value; // Получаем значение repeat
//     looping = !looping;
//     sendCommand('setLooping', { looping: looping, repeat: parseInt(repeatValue, 10) }); // Отправляем команду на установку зацикливания
//     console.log("Установлено зацикливание: ", looping ? "включено" : "выключено");
// });

document.getElementById('getDeviceStateButton').addEventListener('click', () => {
    sendCommand('readDeviceState');
});
