const net = require('net');

//Проверяет, является ли заданная переменная URL ссылкой
function isValidURL(text) {
    return (!!text && text.toString().match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g) !== null);
};

//проверяет переданные в init опции, возвращает пустую строку или строку ошибок
function checkInitOptions (options) {
    let errorsList = '';
    //Настройки подключения к сигнальному серверу
    if (net.isIP(options.serverIp) === 0) {
        errorsList += '\n   "serverIp": Ip-адрес сигнального сервера. Адрес IPv4 должен иметь формат X.X.X.X, где X - число от 0 до 255. Задан: ' + options.serverIp;
    };
    if (options.serverPort === null || options.serverPort === '' || Number.isNaN(Number(options.serverPort)) || !Number.isInteger(Number(options.serverPort))) {
        errorsList += '\n   "serverPort": Порт сигнального сервера. Порт должен задаваться целым числом в диапозоне 0 до 65535. Задан: ' + options.serverPort;
    };
    //Настройки клиента
    if (options.clientType !== 'receiver' && options.clientType !== 'provider') {
        errorsList += '\n   "clientType": Тип клиента. Необходимо выбрать один из двух вариантов: "receiver" - клиент или "provider" - оператор. Задан: ' + options.clientType;
    }
    if (!options.platformId || typeof options.platformId !== 'string') {
        errorsList += '\n   "platformId": Id платформы. Задан: ' + options.platformId;
    }
    if (!options.platformName || typeof options.platformName !== 'string') {
        errorsList += '\n   "platformName": Название платформы. Задан: ' + options.platformName;
    }
    return errorsList;
}

//добавляет новые поля в settings, в зависимости от типа типа клиента (receiver или provider)
function updateSettingsComposition(settings, type, receiverSettings, providerSettings) {
    const entries = type === 'provider' ?
        Object.entries(providerSettings) :
        Object.entries(receiverSettings);
    entries.forEach(([key, value]) => {
        settings[key] = value;
    })  
}

//устанавливает настройки, согласно переданным в init параметрам
function updateSettings(settings, options) {
    /* в options передан параметр stunServer, обновляем значение в settings,
    если нет, используем значение по умолчанию*/
    if (options.stunServer) {
        settings.stunServer === options.stunServer;
    }
    if (options.reconnectTime && options.reconnectTime !== '' && !Number.isNaN(Number(options.reconnectTime)) && Number.isInteger(Number(options.reconnectTime))) {
        settings.reconnectTime = options.reconnectTime;
    };
    if (isValidURL(options.stunServer)) settings.stunServer = options.stunServer;
    if (options.deviceName && typeof options.deviceName === 'string') settings.name = options.deviceName;
    if (options.floor && options.floor !== '' && !Number.isNaN(Number(options.floor)) && Number.isInteger(Number(options.floor))) {
        settings.floor = options.floor;
    };
    if (options.positionX && options.positionX !== '' && !Number.isNaN(Number(options.positionX)) && Number.isInteger(Number(options.positionX))) {
        settings.location.x = options.positionX;
    };
    if (options.positionY && options.positionY !== '' && !Number.isNaN(Number(options.positionY)) && Number.isInteger(Number(options.positionY))) {
        settings.location.y = options.positionY;
    };
    if (options.orientationX && options.orientationX !== '' && !Number.isNaN(Number(options.orientationX)) && Number.isInteger(Number(options.orientationX))) {
        if (Number(options.orientationX) >= -1 && Number(options.orientationX) <= 1) settings.orientation.x = options.orientationX;
    };
    if (options.orientationY && options.orientationY !== '' && !Number.isNaN(Number(options.orientationY)) && Number.isInteger(Number(options.orientationY))) {
        if (Number(options.orientationY) >= -1 && Number(options.orientationY) <= 1) settings.orientation.y = options.orientationY;
    };
    //Настройки камеры
    //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    if (options.camRotate === 'none' || options.camRotate === 'left' || options.camRotate === 'right' || options.camRotate === 'invert') settings.camSet.rotate = options.camRotate;
    if (options.camInvertX === true) settings.camSet.invertX = true;
    if (options.camInvertY === true) settings.camSet.invertY = true;
    //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    if (options.microphoneSensitivity && options.microphoneSensitivity !== '' && Number(options.microphoneSensitivity) != NaN && Number.isInteger(Number(options.microphoneSensitivity))) {
        if (Number(options.microphoneSensitivity) >= 0 && Number(options.microphoneSensitivity) <= 100) settings.microphoneSensitivity = options.microphoneSensitivity;
    };
    settings.type = options.clientType;
    settings.platform.id = options.platformId;
    settings.platform.name = options.platformName;
}

module.exports = {
    checkInitOptions,
    updateSettings,
    updateSettingsComposition
}