# Модуль #
> Версия: 2.1.1

---

## Описание:
> Модуль сбора и отправки на сервер статистики работы приложения.

## Структура:
* Основной файл - index.js используется для работы с инициализацией модуля и объединения экспортов всего модуля. В папке src находятся файлы "автономного сбора сетевой статистики" (netStat.ts), "статистики пользовательских сессий" (sessions.ts) и "статистики рекламного модуля neuroAd" (neuroAd.ts). Каждый исходный .ts файл имеет скомпилированную .js версию, предназначенную для работы без предварительной компиляции.

## Подключение:
* ### Посмотреть пример работы пакета:
	1. Установить пакет: npm install @neuro-city/statistic;
	1. Перейти в корневую директорию модуля common/statistic;
	1. Выполнить npm i;
	1. Перейти в директорию запуска примера работы модуля common/statistic/example;
	1. Выполнить npm i;
	1. Запустить пример: npm run example;
* ### Подключить пакет к проекту:
	1. Установить пакет: npm install @neuro-city/statistic;
	2. Импортировать модуль в необходимый файл кода ( const commonStatistic = require('@neuro-city/statistic') ).
	3. Инициализировать модуль (commonStatistic.init()), функция принимает объект со следующими полями:
		1. device - string, ID устройства, на котором запущен
		2. serverAddress - string, адрес сервера, на который отправлять статистику
		3. serverPort - string, порт сервера, на который отправлять статистику
		4. collectStatistics - bool, собирать ли статистику пользования устройством
		5. sendStatistics - bool, отправлять ли статистику пользования устройством
		6. logsPath - string, путь сохранения записей статистики
		7. interval - number, интервал отправки статистики, секунды
		8. devicePlace - string, ID места устройства
		9. idleTime - number, задержка между последним действием пользователя и окончанием сессии, секунды
		10. workInterval - number, частота записи информации о работе устройства, секунды
		11. collectNetStat - boolean, собирать ли сетевую статистику

## Интерфейс:
* ### Интерфейс
	1. .init - см. раздел подключения
	2. .start - запускает модуль статистики 
	3. .stop - останавливает работу модуля статистики
	4. .startSession - запускает сбор пользовательской статистики (использовать в методе обработки начала пользовательской сессии), принимает объект со следующими полями:
		1. startLang - string, язык интерфейса на момент начала сессии, без указания не будет обрабатывать смену языка (необязательный, в проектах, не требующих отслеживания статистики по языкам можно не указывать)
		2. startTheme - string, тема на момент начала сессии, работает аналогично языку
	5. .endSession - заканчивает сбор статистики по текущей сессии и передает в основную часть модуля для дальнейшей отправки (использовать в методе обработки окончания сессии)
	6. .changeTheme - записывает инфо о новой теме оформления, вызвать можно только во время пользовательской сессии, у которой указана начальная тема, параметры:
		1. string, название новой темы
	7. .changeLang - записывает инфо о новом языке, вызывать можно только во время пользовательской сессии, у которой указан начальный язык, параметры:
		1. string, название нового языка
	8. .addPathQuery - записывает инфо о запросе на построение пути, вызывать можно только во время пользовательской сессии
	9. .addMenuClick - записывает инфо о клике на элемент меню, вызывать можно только во время пользовательской сессии, параметры: 
		1. string, название элемента меню (туалет, категории, рестораны и т.д.)
	10. .addCategoryAction - записывает инфо о действии с категориями, вызывать можно только во время пользовательской сессии, параметры:
		1. string, название категории (APPLE, сумки, багаж, обувь и т.д.)
		2. string ("clickCount" | "voiceCount" | "keyboardCount"), тип запроса - клик, голосовой или с клавиатуры
	11. .addTakemobile - записывает инфо о передаче инфо\звонка на телефон пользователя, можно использовать только во время пользовательской сессии, параметры:
		1. string, номер телефона клиента
		2. string ("googlePlay" | "appStore"), опциональный параметр, если пользователь забирает приложение - указываем, через какой магазин
	12. .startVideophone - записывает инфо о начале нового звонка по видеофону, можно использовать только во время пользовательской сессии
	13. .endVideophone - записывает инфо об окончании звонка по видеофону, можно использовать только во время пользовательской сессии, если обработка звонка узе запущена.
	14. .handleNeuroAdStart - записывает инфо о старте проигрывания рекламного ролика, параметры:
		1. string, название ролика
		2. string ("session"|"idle"), тип проигывания, в пользовательской сессии или в режиме простоя
	15. .handleNeuroAdClick - записывает инфо о клике по рекламному ролику, параметры:
		1. string, название ролика
		2. string, опциональный параметр - если значение 'takemobile' - записывает клик в поле takemobile, если отсутствует или отличается от 'takemobile' - в обычные клики
	16. .handleNeuroAdTakemobile - записывает инфо о том, что клиент забрал рекламную информацию на телефон, параметры:
		1. string, название ролика
		2. string, номер телефона клиента
	17. .addEventAction - записывает инфо о действии с событиями, вызывать можно только во время пользовательской сессии, параметры:
		1. string, название события
		2. string ("clickCount" | "voiceCount" | "keyboardCount"), тип запроса - клик, голосовой или с клавиатуры
	18. .addObjectAction - записывает инфо о действии с приоритетными объектами, вызывать можно только во время пользовательской сессии, параметры:
		1. string, название объекта
		2. string ("clickCount" | "voiceCount" | "keyboardCount"), тип запроса - клик, голосовой или с клавиатуры
		3. string, опциональный параметр, тип объекта (сейчас используется в виде "brand" или "top-brand")
	19. .handleFlightRegistration, без параметров - записывает время регистрации на полет
	20. .finalizeWorkTimes - записывает незаконченный отчет о времени работы устройства в файл. Вызывается перед выключением устройства.
	21. .handleSearchQuery - записывает информацию о поисковом запросе и его результате, принимает параметры:
		1. query: string - текст поискового запроса
		2. keywords: string[] - массив ключевых слов (по которым был найден результат), если нет результата - передаем пустой
		3. result: string - ID найденного объекта, если резальтата нет - пустая строка
* ### Примечание
	1. Обработка статистики начинается только после инициализации (п. 1) и запуска (п. 2) модуля
	2. Методы работы с данными пользовательской сессии (пп. 5-13) доступны к вызову только после вызова метода начала сессии (п.4)

* ### Changelog
	1. Версия 1.0.1:
		1. Исправлен баг, возникающий при попытке завершить неначатую сессию.
	2. Версия 1.0.2:
		1. Изменен вызов начала сессии, теперь не нужно указывать время неактивности, берется из общей инициализации модуля.
	3. Версия 1.0.3:
		1. Исправлен баг, засоряющий консоль некорректными выхлопами об отключенном сборе статистики
	4. Верссия 1.0.5:
		1. Исправлен баг, возникающий при отсутствии адреса и порта сервера при инициализации
	5. Версия 1.0.6
		1. Теперь, если при инициализации модуля не указать адрес сервера, статистика не будет отправляться на тестовый
	6. Версия 1.0.10
		1. Исправлен баг отправки старых записей, возникающий при наличии пустого файла .stat
	7. Версия 2.1.0
		1. В инициализацию добавлен параметр workInterval
		2. Добавлен метод .addEventAction
	8. Версия 2.1.1
		1. Добавлена задержка в цикле повторной отправки записей статистики
		2. Правки ридми
	9. Версия 2.1.2
		1. Исправлен баг повторной отправки уже отправленной записи
	10. Версия 2.3.0
		1. Добавлен метод finalizeWorkTimes