"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const NetEventEmitter = require('events');
class netEmitterClass extends NetEventEmitter {
}
const netEmitter = new netEmitterClass();
const onNetStart = (e, action) => netEmitter.on(e, (data) => action(data));
const pings = [];
const speeds = [];
let netInterval = null;
let netSendInterval = 1000;
let host = 'http://google.com';
let defaultUrl = 'https://upload.wikimedia.org/wikipedia/commons/thumb/b/b9/Pizigani_1367_Chart_1MB.jpg/800px-Pizigani_1367_Chart_1MB.jpg';
/** Функция возвращает массив статистических данных для выбранного типа, а также сбрасывает данные в массиве */
const getStats = (key) => {
    let result = [];
    if (key === 'ping') {
        result = [...pings];
        pings.length = 0;
    }
    if (key === 'speed') {
        result = [...speeds];
        speeds.length = 0;
    }
    return result;
};
/** Инициализация модуля, установка парметров(интервал, URL-адрес хоста и URL-адрес изображения) */
const initNetStart = ({ checkInterval, initHost, imgUrl }) => {
    netSendInterval = checkInterval ? checkInterval : netSendInterval;
    host = initHost ? initHost : host;
    defaultUrl = imgUrl ? imgUrl : defaultUrl;
};
/** Запуск модуля сбора статистики(устанавливает интервал, который отправляет запросы и собирает данные) */
const startNetStart = () => {
    netInterval = setInterval(() => __awaiter(void 0, void 0, void 0, function* () {
        const time = +new Date();
        pings.push(yield getPing(time));
        speeds.push(yield getSpeed(time));
    }), netSendInterval);
};
/** Остановка сбора статистики, с уведомлением(был уже запущен/остановлен) */
const stopNetStart = () => {
    if (netInterval === null) {
        netEmitter.emit('info', 'модуль сетевой статистики не запущен');
        return;
    }
    clearInterval(netInterval);
    netEmitter.emit('info', 'модуль сетевой статистики остановлен');
};
/** Асинхронно отправляет запрос к указанному хосту и возвращает статистику пинга. */
const getPing = (time) => __awaiter(void 0, void 0, void 0, function* () {
    const start = Date.now();
    try {
        yield fetch(host);
    }
    catch (error) {
        netEmitter.emit('error', 'host unreachable');
    }
    return {
        hoursStart: time,
        value: Date.now() - start,
    };
});
/** Асинхронно загружает изображение и возвращает статистику скорости сети. */
const getSpeed = (time) => __awaiter(void 0, void 0, void 0, function* () {
    const imageAddr = defaultUrl;
    const downloadSize = (yield (yield fetch(imageAddr)).blob()).size;
    return new Promise((resolve, reject) => {
        let startTime, endTime;
        const download = new Image();
        download.onload = function () {
            endTime = new Date().getTime();
            const duration = (endTime - startTime) / 1000;
            const bitsLoaded = downloadSize * 8;
            const speedMbps = +(bitsLoaded / duration / 1048576).toFixed(2);
            resolve({
                hoursStart: time,
                value: speedMbps,
            });
        };
        download.onerror = function (_, msg) {
            netEmitter.emit('error', `Cannot reach resource: ${msg}`);
            reject({
                hoursStart: Date.now(),
                value: 0,
            });
        };
        startTime = new Date().getTime();
        const cacheBuster = '?nnn=' + startTime;
        download.src = imageAddr + cacheBuster;
    });
});
module.exports = {
    onNetStart,
    getStats,
    initNetStart,
    startNetStart,
    stopNetStart,
};
/*
Модуль для сбора статистики сети, который предоставляет функции для настройки,
запуска и остановки сбора статистики, а также для получения собранной статистики о пинге
и скорости сети.
*/
