"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
const events_1 = __importDefault(require("events"));
const emitter = new events_1.default();
class Schedule {
    constructor(start, end, interval) {
        // Генерируем массив периодов на основе заданных параметров
        this.schedule = Array.from({ length: (end - start) / interval + 1 }, (_, i) => start + interval * i);
        // Определяем начальное значение текущего периода
        this.currentPeriod = this.findCurrentPeriod();
    }
    // Метод для определения текущего периода
    findCurrentPeriod() {
        let now = Date.now();
        // Проходим по расписанию и ищем ближайший период
        for (let i = 1; i < this.schedule.length; i++) {
            if (this.schedule[i] >= now) {
                return i - 1;
            }
        }
        // Если текущее время за пределами расписания
        return -1;
    }
    // Метод для запуска таймера
    start() {
        // console.log(
        //     this.schedule.map((el) =>
        //         new Date(el).toLocaleTimeString('en-US', {
        //             timeZone: 'Europe/Moscow',
        //             hour12: false,
        //         })
        //     )
        // );
        // Устанавливаем интервальный таймер
        this.interval = setInterval(() => {
            // Определяем текущий период
            const newPeriod = this.findCurrentPeriod();
            // Если расписание завершено
            if (newPeriod === -1) {
                // Генерируем событие "schedule-end"
                emitter.emit('schedule-end');
                // Останавливаем таймер
                this.stop();
                return;
            }
            // Если произошло изменение периода
            if (newPeriod !== this.currentPeriod) {
                // Обновляем текущий период
                this.currentPeriod = newPeriod;
                // Генерируем событие "interval" с информацией о новом интервале
                emitter.emit('interval', 'new interval: ' +
                    new Date(this.schedule[this.currentPeriod]).toISOString());
            }
        }, 1000);
    }
    // Метод для остановки таймера
    stop() {
        // Очищаем интервал таймера
        clearInterval(this.interval);
    }
    // Метод для подписки на событие
    on(name, action) {
        // Добавляем обработчик события
        emitter.on(name, action);
    }
}
exports.Schedule = Schedule;
