/// <reference path="./sessions.d.ts" />
/// <reference path="./netStat.d.ts" />
/// <reference path="./statistics.d.ts" />
/// <reference path="./neuroAd.d.ts" />

type lang = {
  name: string;
  queryCount: number;
  sessionCount: number;
};

type langs = lang[];

type theme = {
  name: string;
  queryCount: number;
  sessionTime: number;
};

type themes = theme[];

type session = {
  time: number;
  pathCount: number;
};

type sessions = session[];

type menuAction = {
  name: string;
  clickCount: number;
};

type menuActions = menuAction[];

type category = {
  name: string;
  clickCount: number;
  voiceCount: number;
  keyboardCount: number;
};

type categories = category[];

type event = {
  name: string;
  clickCount: number;
  voiceCount: number;
  keyboardCount: number;
}

type events = event[];

type priorityObject = {
  name: string;
  type: string;
  clickCount: number;
  voiceCount: number;
  keyboardCount: number;
};

type objects = priorityObject[];

type videophone = {
  time: number;
  count: number;
};

type videophones = videophone[];

type client = string;

type takemobile = {
  clients: client[];
  appStoreCount: number;
  googlePlayCount: number;
  takeMobileClick: number;
};

type takemobiles = takemobile[];

type neuroAd = {
  type?: string;
  name: string;
  clickCount: number;
  playCount: number;
  playCountIdle: number;
  takeMobileClick: number;
  takeMobileCount: number;
  clients: client[];
};

type mainProps = {
  device: string;
  serverAddress: string;
  serverPort?: string;
  sendStatistics: boolean;
  logsPath: string;
  interval: number;
  devicePlace: string;
  collectStatistics: boolean;
  idleTime: number;
  workInterval: number;
  collectNetStat: boolean;
  startPeriod:number,
  endPeriod:number,
};

type currentSession = {
  sessionTime?: number;
  langs?: string[] | null;
  themes?: theme[] | null;
};

type connectionSpeed = {
  hoursStart: number;
  name: "maxSpeed" | "middleSpeed" | "minSpeed";
  value: number;
};

type connectionSpeeds = connectionSpeed[];

type ping = {
  hoursStart: number;
  name: "maxPing" | "middlePing" | "minPing";
  value: number;
};

type pings = ping[];

type workTime = {
  hoursStart: number;
  interval: number;
}

type registration = {
  time: number;
  ticketNumber: string;
  flightNumber: string;
  status: string;
  error: string;
};

type sms = {
  phoneNumber: string;
  time: number;
  status: string;
  error: string;
}

type mail = {
  email: string;
  time: number;
  status: string;
  error: string;
}

type ArrElement<ArrType> = ArrType extends readonly (infer ElementType)[]
? ElementType
: never;

type ArrayElementType<T> = T extends (infer E)[] ? E : T;
