# Модуль Watchdog #
> Версия: 1.0.1

---

## Описание:
> Модуль предназначен для управления устройством [Watchdog PRO2 USBA](https://open-dev.ru/watchdog).

## Структура:
* `example` содержит скрипт показывающий работу модуля
* `scripts` содержит скрипт для "усыпления" устройтства *Watchdog* при старте системы и заданию ему псевдонима `/dev/watchdog`

## Подключение:
* ### Подключение устройства *Watchdog* (далее "устройство"): 
	1. Способ подключения и получение номера порта можно узнать из [технической документации](https://files.digiowls.org/doc/usb-watchdog-pro2-2018.pdf)
* ### Посмотреть пример работы пакета:
	1. Установить пакет: `npm install @neuro-city/watchdog`
	1. Для *Linux* подобных систем необходио запустить скрипт `watchdog-install.sh` из `./node_modules/@neuro-city/watchdog/scripts`
	1. Перейти в директорию с примером работы: `cd ./node_modules/@neuro-city/watchdog/example`
	1. Запустить пример: `node index.js`
* ### Подключить пакет к проекту:
	1. Установить пакет: `npm install @neuro-city/watchdog`
	1. Создать переменную пакета: `const watchdog = require('@neuro-city/watchdog)`;

## Интерфейс:
* ### Команды:
	* **connect** - запускает поиск устройства и, в случае успеха подключается к нему. Принимаемый параметр `portPath: string (название порта вида "COM0" для Windows или "/dev/ttyACM0" для Linux)`. Если параметр не задан или устройство не найдено на заданном порту, поиск продолжается по всем доступным портам.
	* **on** - возвращает `callback` на следующие события:
		* **connect** - при успешном подключении к устройству
		* **disconnect** - при потери связи с устройством
		* **data** - вывод данных модуля
		* **error** - вывод ошибок модуля
	* **setSettings** - задаёт настройки устройству. Принимает параметр `params: string` (11 символов, где:
		* 1 - Ожидание сигнала перезагрузки (1 мин*****);
		* 2 - Длительность импульса сигнала "Reset" (100 мс*****);
		* 3 - Длительность импульса сигнала "Power" (1 с*****);
		* 4 - Длительность ожиданий (1 с*****);
		* 5 - Длительность импульса сигнала "Power" (100 мс*****);
		* 6 - Режим канала: 1: 0-выкл, 1-RESET, 2-POWER, 3-Управлсемый(нач.сост.-открыт), 4-Управлсемый(нач.сост.-закрыт);
		* 7 - Режим канала: 2: 0-выкл, 1-RESET, 2-POWER, 3-Управлсемый(нач.сост.-открыт), 4-Управлсемый(нач.сост.-закрыт);
		* 8 - Ограничение кол-ва перезагрузок. 0-нет ограничений;
		* 9 - Режим канала 3 (Bx/Ln): 0-выкл, 1-дискретный вход, 3-вход датчика температуры ds18b20;
		* 10, 11 - Пороговое значение температуры для автоматического перезапуска. Неактуально при канале 3 (Bx/Ln) = 3. в шестнадцатеричном формате, например: 32 градуса - 20, 80 градусов - 50, 00 - отключено.
		* *****значения параметров 1-5 могут быть в диапазоне 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, A(10), B(11), C(12), D(13), E(14), F(15).
	* **start** - запускает вещание в модуль. Принимает параметр `interval: any` (текстовое или численное значение интервала отправки сообщений устройству в секундах, по умолчанию 1 сек.)
	* **stop** - отсанавливает вещание в модуль и ставит его на паузу
* ### Примечание:
	* Все команды устройтсву, кроме `connect`, необходимо размещать в колбеке события `connect`
