const settings = '22532120300';
// Настройки модуля принимаются в виде строки из 11 символов (0 - 9, A - F), где:
// 1 - Ожидание сигнала перезагрузки (1 мин*);
// 2 - Длительность импульса сигнала "Reset" (100 мс*);
// 3 - Длительность импульса сигнала "Power" (1 с*);
// 4 - Длительность ожиданий (1 с*);
// 5 - Длительность импульса сигнала "Power" (100 мс*);
// 6 - Режим канала: 1: 0-выкл, 1-RESET, 2-POWER, 3-Управлсемый(нач.сост.-открыт), 4-Управлсемый(нач.сост.-закрыт);
// 7 - Режим канала: 2: 0-выкл, 1-RESET, 2-POWER, 3-Управлсемый(нач.сост.-открыт), 4-Управлсемый(нач.сост.-закрыт);
// 8 - Ограничение кол-ва перезагрузок. 0-нет ограничений;
// 9 - Режим канала 3 (Bx/Ln): 0-выкл, 1-дискретный вход, 3-вход датчика температуры ds18b20;
// 10, 11 - Пороговое значение температуры для автоматического перезапуска. Неактуально при канале 3 (Bx/Ln) = 3. в шестнадцатеричном формате, например: 32 градуса - 20, 80 градусов - 50, 00 - отключено.
// *значения параметров 1-5 могут быть в диапазоне 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, A(10), B(11), C(12), D(13), E(14), F(15).

const linuxComPort = '/dev/watchdog'; //Если скрипт scripts/watchdog-install.sh не запускался, название порта будет ttyACMX, где X - номер порта
const windowsComPort = 'COM1'; //Может отличаться. Необходимо проверить при подключении устройства в Диспетчре устройств в разделе "Порты (COM и LPT)"
const watchdogAliveTime = 5; //Время жизни устройства (сек). 0 = неограничено

try {
    const watchdog = require('../../watchdog');

    console.log('[watchdog] Запущен поиск модуля Watchdog');
    watchdog.connect(process.platform === 'linux' ? linuxComPort : windowsComPort);

    //Обработка события подключения к устройству
    watchdog.on('connect', () => {
        console.log('[watchdog] Задаём настройки модуля:', settings);
        watchdog.setSettings(settings);
        console.log('[watchdog] Вещание в модуль запущено');
        watchdog.start();
        
        //Механизм остановки вещания в модуль по таймеру
        if (watchdogAliveTime !== 0) {
            setTimeout(() => {
                console.log('[watchdog] Вещание в модуль остановлено. Устройство поставлено на паузу');
                watchdog.stop();
            }, watchdogAliveTime * 1000);
        };
    });

    //Обработка события отключения от устройства
    watchdog.on('disconnect', () => {
        console.error('[watchdog] Связь с модулем Watchdog потеряна');
    });

    //Вывод данных
    watchdog.on('data', (data) => {
        console.log('[watchdog] Data:', data);
    });

    //Вывод ошибок
    watchdog.on('error', (error) => {
        console.error('[watchdog] Error:', error);
    });

} catch (error) {
    console.error('[watchdog] В работе модуля Watchdog возникли ошибки:', error);
};